<?php

@session_start();
// Configuration des chemins de base
define('APP_ROOT', dirname(__DIR__));

// Autoload des classes
spl_autoload_register(function ($class) {
    $paths = [
        APP_ROOT . '/app/controllers/',
        APP_ROOT . '/app/models/',
        APP_ROOT . '/app/routers/',
        APP_ROOT . '/app/kernel/'
    ];
    
    foreach ($paths as $path) {
        $file = $path . $class . '.php';
        if (file_exists($file)) {
            require_once $file;
            return;
        }
    }
});

// Appel du routeur principal
$router = new PrincipalRouter();
$request = new Request($_GET, $_POST, $_SERVER);
$router->handleRequest($request->getUri());

?>