<!DOCTYPE html>
<html lang="fr">
<head>
    
  <meta charset="UTF-8">
  <title>Modifier mon profil - BeWise</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  

  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="icon" href="favicon.ico" type="../image/x-icon" />
  <!-- END META SECTION -->
  <!-- CSS INCLUDE -->        
  <link rel="stylesheet" type="text/css" id="theme" href="../css/theme-default.css"/>
  <!-- EOF CSS INCLUDE --> 
  
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4f6f9;
      margin: 0;
      padding: 0;
      display: flex;
      flex-direction: column;
      align-items: center;
    }

    form {
      background-color: white;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
      padding: 30px;
      width: 90%;
      max-width: 600px;
      margin: 40px auto;
    }

    h2 {
      text-align: center;
      color: #343a40;
      margin-bottom: 30px;
      font-size: 26px;
    }

    label {
      display: block;
      margin-top: 15px;
      font-weight: bold;
      color: #007bff;
    }

    input, select, textarea {
      width: 100%;
      padding: 10px;
      margin-top: 5px;
      border: 1px solid #ccc;
      border-radius: 6px;
      font-size: 15px;
      background-color: #fdfdfd;
    }

    textarea {
      resize: vertical;
      min-height: 80px;
    }

    button {
      margin-top: 25px;
      padding: 12px 20px;
      background-color: #28a745;
      color: white;
      border: none;
      border-radius: 8px;
      font-size: 16px;
      cursor: pointer;
      width: 100%;
      transition: background-color 0.3s;
    }

    button:hover {
      background-color: #218838;
    }

    .back-link {
      display: block;
      text-align: center;
      margin-top: 25px;
      color: #6c757d;
      text-decoration: none;
      font-weight: bold;
    }

    .back-link:hover {
      color: #343a40;
    }

    footer {
      margin: 40px 0 20px;
      font-size: 14px;
      color: #888;
      text-align: center;
    }
    

.alert {
    display: flex;
    align-items: center;
    gap: 10px;
    border: 1px solid transparent;
}
.alert-success {
    color: #155724;
    background-color: #d4edda;
    border-color: #c3e6cb;
}
.alert-danger {
    color: #721c24;
    background-color: #f8d7da;
    border-color: #f5c6cb;
}
.alert-warning {
    color: #856404;
    background-color: #fff3cd;
    border-color: #ffeeba;
}
.alert-info {
    color: #0c5460;
    background-color: #d1ecf1;
    border-color: #bee5eb;
}


  </style>
</head>
<body>
  <?php
    if (session_status() === PHP_SESSION_NONE) @session_start();
    $u = $_SESSION['user'];
  ?>
  <form method="POST" action="../index.php/update_profil/<?= $u['id_utilisateur'] ?>">
    <h2><i class="fas fa-user-edit"></i> Modifier mon profil</h2>

    <label>Nom :</label>
    <input type="text" name="nom" value="<?= $u['nom'] ?>" required>

    <label>Prénom :</label>
    <input type="text" name="prenom" value="<?= $u['prenom'] ?>" required>

    <label>Téléphone :</label>
    <input type="number" name="email" value="<?= $u['email'] ?>" required>

    <label>Genre :</label>
    <select name="genre">
      <option <?= $u['genre'] === 'Masculin' ? 'selected' : '' ?>>Masculin</option>
      <option <?= $u['genre'] === 'Féminin' ? 'selected' : '' ?>>Féminin</option>
    </select>

    <label>Date de naissance :</label>
    <input type="date" name="date_naissance" value="<?= $u['date_naissance'] ?>">

    <label>Niveau d'éducation :</label>
    <input type="text" name="niveau_education" value="<?= $u['niveau_education'] ?>">

    <label>Profession :</label>
    <input type="text" name="profession" value="<?= $u['profession'] ?>">

    <label>Type utilisateur :</label>
    <select name="type_utilisateur">
      <option <?= $u['type_utilisateur'] === 'simple' ? 'selected' : '' ?>>simple</option>
      <option <?= $u['type_utilisateur'] === 'admin' ? 'selected' : '' ?>>admin</option>
      <option <?= $u['type_utilisateur'] === 'analyste' ? 'selected' : '' ?>>analyste</option>
    </select>

    <label>Motivation financière :</label>
    <textarea name="motivation_financiere"><?= $u['motivation_financiere'] ?></textarea>

    <label>Profil de risque :</label>
    <select name="profil_risque">
      <option <?= $u['profil_risque'] === 'faible' ? 'selected' : '' ?>>faible</option>
      <option <?= $u['profil_risque'] === 'moyen' ? 'selected' : '' ?>>moyen</option>
      <option <?= $u['profil_risque'] === 'élevé' ? 'selected' : '' ?>>élevé</option>
    </select>

    <button type="submit"><i class="fas fa-save"></i> Enregistrer les modifications</button>
    <a href="../index.php/dashboard" class="back-link"><i class="fas fa-arrow-left"></i> Retour au tableau de bord</a>
  </form>

  <footer>
    Discipline et liberté financière : la voix vers la richesse.
  </footer>

<div id="toast-success" class="toast">
  <i class="fas fa-check-circle"></i> Modifications enregistrées avec succès !
</div>


</body>
</html>
