<!DOCTYPE html>
<html lang="fr">
<head>
    <title>Statistiques Financières - BeWise</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="icon" href="favicon.ico" type="../image/x-icon" />
  <!-- END META SECTION -->
  <!-- CSS INCLUDE -->        
  <link rel="stylesheet" type="text/css" id="theme" href="../css/theme-default.css"/>
  <!-- EOF CSS INCLUDE -->   
    <style>
        /* Style général */
        body {
            font-family: 'Segoe UI', sans-serif;
            background-color: #f8fafc;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        h1 {
            color: #2c3e50;
            text-align: center;
            margin: 20px 0 30px;
            padding-bottom: 15px;
            border-bottom: 3px solid #3498db;
            font-size: 28px;
        }

        /* Cartes */
        .card {
            background-color: white;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
            padding: 25px;
            margin-bottom: 30px;
            transition: all 0.3s ease;
            border-top: 4px solid;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
        }

        /* Couleurs des cartes par catégorie */
        .card-sessions { border-top-color: #6c757d; }
        .card-revenus-donnes { border-top-color: #28a745; }
        .card-revenus-recus { border-top-color: #20c997; }
        .card-dettes-octroyees { border-top-color: #ffc107; }
        .card-dettes-recues { border-top-color: #fd7e14; }
        .card-gains { border-top-color: #17a2b8; }
        .card-financements { border-top-color: #6610f2; }

        /* Titres */
        .section-title {
            color: #2c3e50;
            font-size: 22px;
            margin: 40px 0 20px;
            padding-left: 15px;
            border-left: 4px solid #3498db;
        }

        .card-title {
            color: #2c3e50;
            font-size: 20px;
            margin-top: 0;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
        }

        .card-title i {
            margin-right: 10px;
            font-size: 24px;
        }

        /* Statistiques */
        .stat-container {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin: 20px 0;
        }

        .stat-box {
            flex: 1;
            min-width: 200px;
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            text-align: center;
            transition: all 0.3s ease;
        }

        .stat-box:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }

        .stat-box h3 {
            color: #6c757d;
            font-size: 16px;
            margin: 0 0 10px;
        }

        .stat-box p {
            font-size: 24px;
            font-weight: 600;
            margin: 0;
            color: #2c3e50;
        }

        /* Tableaux */
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            background-color: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        th, td {
            padding: 15px;
            text-align: left;
            border-bottom: 1px solid #e9ecef;
        }

        th {
            background-color: #3498db;
            color: white;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 14px;
        }

        tr:nth-child(even) {
            background-color: #f8f9fa;
        }

        tr:hover {
            background-color: #f1f8fe;
        }

        /* Montants */
        .montant {
            text-align: right;
            font-weight: 600;
            font-family: 'Courier New', monospace;
        }

        .montant.positif {
            color: #28a745;
        }

        .montant.negatif {
            color: #dc3545;
        }

        /* Messages d'absence de données */
        .no-data {
            text-align: center;
            padding: 20px;
            color: #6c757d;
            font-style: italic;
            background-color: #f8f9fa;
            border-radius: 8px;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .stat-container {
                flex-direction: column;
            }
            
            .stat-box {
                width: 100%;
            }
            
            table {
                display: block;
                overflow-x: auto;
            }
        }

        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .card {
            animation: fadeIn 0.5s ease-out forwards;
        }

        /* Délais d'animation pour les cartes */
        .card:nth-child(1) { animation-delay: 0.1s; }
        .card:nth-child(2) { animation-delay: 0.2s; }
        .card:nth-child(3) { animation-delay: 0.3s; }
        .card:nth-child(4) { animation-delay: 0.4s; }
        .card:nth-child(5) { animation-delay: 0.5s; }

        /* Pied de page */
        footer {
            text-align: center;
            margin-top: 50px;
            padding: 20px;
            color: #6c757d;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1><i class="fas fa-chart-line"></i> Statistiques Financières</h1>
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <h2>L'essentiel de votre finance est ici.</h2>
            <a href="../index.php/dashboard" style="text-decoration: none;">
                <button style="padding: 8px 15px; background-color: #4CAF50; color: white; border: none; border-radius: 4px; cursor: pointer;">
                    Retour au Dashboard
                </button>
            </a>
        </div>        
        <!-- Sessions de connexion -->
        <div class="card card-sessions">
            <h2 class="card-title"><i class="fas fa-sign-in-alt"></i> Sessions de connexion</h2>
            <div class="stat-container">
                <div class="stat-box">
                    <h3>Total sessions</h3>
                    <p><?= $data['sessions']['total_sessions'] ?? 0 ?></p>
                </div>
                <div class="stat-box">
                    <h3>Sessions fermées</h3>
                    <p><?= $data['sessions']['sessions_fermees'] ?? 0 ?></p>
                </div>
                <div class="stat-box">
                    <h3>Sessions non fermées</h3>
                    <p><?= $data['sessions']['sessions_non_fermees'] ?? 0 ?></p>
                </div>
                <div class="stat-box">
                    <h3>Durée totale</h3>
                    <p><?= $data['sessions']['duree_totale'] ?? '00:00:00' ?></p>
                </div>
                <div class="stat-box">
                    <h3>Durée moyenne</h3>
                    <p><?= $data['sessions']['duree_moyenne'] ?? '00:00:00' ?></p>
                </div>
            </div>
        </div>
        
        <!-- Revenus -->
        <h2 class="section-title"><i class="fas fa-hand-holding-usd"></i> Revenus</h2>
        
        <!-- Revenus donnés -->
        <div class="card card-revenus-donnes">
            <h2 class="card-title"><i class="fas fa-share-square"></i> Revenus donnés</h2>
            <?php if (!empty($data['revenus']['donnes']['liste'])): ?>
            <table>
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Bénéficiaire</th>
                        <th class="montant">Montant</th>
                        <th>Source</th>
                        <th>Catégorie</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($data['revenus']['donnes']['liste'] as $revenu): ?>
                    <tr>
                        <td><?= date('d/m/Y', strtotime($revenu['date_revenu'])) ?></td>
                        <td><?= htmlspecialchars($revenu['prenom'] . ' ' . $revenu['nom']) ?></td>
                        <td class="montant positif"><?= number_format($revenu['montant'], 2, ',', ' ') ?> FCFA</td>
                        <td><?= htmlspecialchars($revenu['source']) ?></td>
                        <td><?= str_replace('_', ' ', $revenu['categorie_revenu']) ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php else: ?>
            <div class="no-data">Aucun revenu donné trouvé.</div>
            <?php endif; ?>
            
            <h3>Totaux revenus donnés</h3>
            <div class="stat-container">
                <div class="stat-box">
                    <h4>Ce mois</h4>
                    <p class="montant positif"><?= number_format($data['revenus']['donnes']['totaux']['total_mois'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
                <div class="stat-box">
                    <h4>Cette année</h4>
                    <p class="montant positif"><?= number_format($data['revenus']['donnes']['totaux']['total_annee'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
                <div class="stat-box">
                    <h4>Total général</h4>
                    <p class="montant positif"><?= number_format($data['revenus']['donnes']['totaux']['total_general'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
            </div>
        </div>
        
        <!-- Revenus reçus -->
        <div class="card card-revenus-recus">
            <h2 class="card-title"><i class="fas fa-receipt"></i> Revenus reçus</h2>
            <?php if (!empty($data['revenus']['recus']['liste'])): ?>
            <table>
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Donneur</th>
                        <th class="montant">Montant</th>
                        <th>Source</th>
                        <th>Catégorie</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($data['revenus']['recus']['liste'] as $revenu): ?>
                    <tr>
                        <td><?= date('d/m/Y', strtotime($revenu['date_revenu'])) ?></td>
                        <td><?= htmlspecialchars($revenu['prenom'] . ' ' . $revenu['nom']) ?></td>
                        <td class="montant positif"><?= number_format($revenu['montant'], 2, ',', ' ') ?> FCFA</td>
                        <td><?= htmlspecialchars($revenu['source']) ?></td>
                        <td><?= str_replace('_', ' ', $revenu['categorie_revenu']) ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php else: ?>
            <div class="no-data">Aucun revenu reçu trouvé.</div>
            <?php endif; ?>
            
            <h3>Totaux revenus reçus</h3>
            <div class="stat-container">
                <div class="stat-box">
                    <h4>Ce mois</h4>
                    <p class="montant positif"><?= number_format($data['revenus']['recus']['totaux']['total_mois'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
                <div class="stat-box">
                    <h4>Cette année</h4>
                    <p class="montant positif"><?= number_format($data['revenus']['recus']['totaux']['total_annee'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
                <div class="stat-box">
                    <h4>Total général</h4>
                    <p class="montant positif"><?= number_format($data['revenus']['recus']['totaux']['total_general'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
            </div>
        </div>
        
        <!-- Dettes -->
        <h2 class="section-title"><i class="fas fa-file-invoice-dollar"></i> Dettes</h2>
        
        <!-- Dettes octroyées -->
        <div class="card card-dettes-octroyees">
            <h2 class="card-title"><i class="fas fa-hand-holding-usd"></i> Dettes octroyées</h2>
            <?php if (!empty($data['dettes']['octroyees']['liste'])): ?>
            <table>
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Emprunteur</th>
                        <th class="montant">Montant</th>
                        <th class="montant">À rembourser</th>
                        <th>Statut</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($data['dettes']['octroyees']['liste'] as $dette): ?>
                    <tr>
                        <td><?= date('d/m/Y', strtotime($dette['date_emprunt'])) ?></td>
                        <td><?= htmlspecialchars($dette['prenom'] . ' ' . $dette['nom']) ?></td>
                        <td class="montant negatif"><?= number_format($dette['montant_emprunt'], 2, ',', ' ') ?> FCFA</td>
                        <td class="montant positif"><?= number_format($dette['montant_remboursement'], 2, ',', ' ') ?> FCFA</td>
                        <td><?= ucfirst($dette['statut']) ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php else: ?>
            <div class="no-data">Aucune dette octroyée trouvée.</div>
            <?php endif; ?>
            
            <h3>Totaux dettes octroyées</h3>
            <div class="stat-container">
                <div class="stat-box">
                    <h4>Ce mois</h4>
                    <p class="montant negatif"><?= number_format($data['dettes']['octroyees']['totaux']['total_mois'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
                <div class="stat-box">
                    <h4>Cette année</h4>
                    <p class="montant negatif"><?= number_format($data['dettes']['octroyees']['totaux']['total_annee'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
                <div class="stat-box">
                    <h4>Total général</h4>
                    <p class="montant negatif"><?= number_format($data['dettes']['octroyees']['totaux']['total_general'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
            </div>
        </div>
        
        <!-- Dettes reçues -->
        <div class="card card-dettes-recues">
            <h2 class="card-title"><i class="fas fa-hand-holding-heart"></i> Dettes reçues</h2>
            <?php if (!empty($data['dettes']['recues']['liste'])): ?>
            <table>
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Prêteur</th>
                        <th class="montant">Montant</th>
                        <th class="montant">À rembourser</th>
                        <th>Statut</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($data['dettes']['recues']['liste'] as $dette): ?>
                    <tr>
                        <td><?= date('d/m/Y', strtotime($dette['date_emprunt'])) ?></td>
                        <td><?= htmlspecialchars($dette['prenom'] . ' ' . $dette['nom']) ?></td>
                        <td class="montant positif"><?= number_format($dette['montant_emprunt'], 2, ',', ' ') ?> FCFA</td>
                        <td class="montant negatif"><?= number_format($dette['montant_remboursement'], 2, ',', ' ') ?> FCFA</td>
                        <td><?= ucfirst($dette['statut']) ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php else: ?>
            <div class="no-data">Aucune dette reçue trouvée.</div>
            <?php endif; ?>
            
            <h3>Totaux dettes reçues</h3>
            <div class="stat-container">
                <div class="stat-box">
                    <h4>Ce mois</h4>
                    <p class="montant positif"><?= number_format($data['dettes']['recues']['totaux']['total_mois'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
                <div class="stat-box">
                    <h4>Cette année</h4>
                    <p class="montant positif"><?= number_format($data['dettes']['recues']['totaux']['total_annee'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
                <div class="stat-box">
                    <h4>Total général</h4>
                    <p class="montant positif"><?= number_format($data['dettes']['recues']['totaux']['total_general'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
            </div>
        </div>
        
        <!-- Gains -->
        <h2 class="section-title"><i class="fas fa-coins"></i> Gains</h2>
        
        <div class="card card-gains">
            <h2 class="card-title"><i class="fas fa-chart-line"></i> Gains</h2>
            <div class="stat-container">
                <div class="stat-box">
                    <h3>Ce mois</h3>
                    <p class="montant positif"><?= number_format($data['gains']['totaux']['total_mois'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
                <div class="stat-box">
                    <h3>Cette année</h3>
                    <p class="montant positif"><?= number_format($data['gains']['totaux']['total_annee'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
                <div class="stat-box">
                    <h3>Total général</h3>
                    <p class="montant positif"><?= number_format($data['gains']['totaux']['total_general'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
            </div>
        </div>
        
        <!-- Financements -->
        <h2 class="section-title"><i class="fas fa-money-bill-transfer"></i> Financements</h2>
        
        <div class="card card-financements">
            <h2 class="card-title"><i class="fas fa-exchange-alt"></i> Financements</h2>
            
            <h3>Financements de dépenses</h3>
            <div class="stat-container">
                <div class="stat-box">
                    <h4>Ce mois</h4>
                    <p class="montant negatif"><?= number_format($data['financements']['depenses']['total_mois'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
                <div class="stat-box">
                    <h4>Cette année</h4>
                    <p class="montant negatif"><?= number_format($data['financements']['depenses']['total_annee'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
                <div class="stat-box">
                    <h4>Total général</h4>
                    <p class="montant negatif"><?= number_format($data['financements']['depenses']['total_general'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
            </div>
            
            <h3>Financements d'épargnes</h3>
            <div class="stat-container">
                <div class="stat-box">
                    <h4>Ce mois</h4>
                    <p class="montant positif"><?= number_format($data['financements']['epargnes']['total_mois'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
                <div class="stat-box">
                    <h4>Cette année</h4>
                    <p class="montant positif"><?= number_format($data['financements']['epargnes']['total_annee'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
                <div class="stat-box">
                    <h4>Total général</h4>
                    <p class="montant positif"><?= number_format($data['financements']['epargnes']['total_general'] ?? 0, 2, ',', ' ') ?> FCFA</p>
                </div>
            </div>
        </div>
        
        <footer>
            Discipline et liberté financière : la voie vers la richesse.
        </footer>
    </div>
</body>
</html>