<?php
// Déplacer cette ligne tout en haut, avant tout code HTML
if (session_status() === PHP_SESSION_NONE) @session_start();

if (isset($_SESSION['flash'])) {
    $flashType = $_SESSION['flash']['type'];
    $flashMessage = $_SESSION['flash']['message'];
    unset($_SESSION['flash']);
    
    $alertClass = '';
    $icon = '';
    
    switch ($flashType) {
        case 'success':
            $alertClass = 'alert-success';
            $icon = 'fa-check-circle';
            break;
        case 'danger':
            $alertClass = 'alert-danger';
            $icon = 'fa-exclamation-circle';
            break;
        case 'warning':
            $alertClass = 'alert-warning';
            $icon = 'fa-exclamation-triangle';
            break;
        default:
            $alertClass = 'alert-info';
            $icon = 'fa-info-circle';
    }
}

$id_utilisateur = $_SESSION['user']['id_utilisateur'];
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    
  <meta charset="UTF-8">
  <title>Gestion des revenus - BeWise</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="icon" href="favicon.ico" type="../image/x-icon" />
  <!-- END META SECTION -->
  <!-- CSS INCLUDE -->        
  <link rel="stylesheet" type="text/css" id="theme" href="../css/theme-default.css"/>
  <!-- EOF CSS INCLUDE --> 
  
  
  <style>
    /* Styles cohérents avec le dashboard */
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4f6f8;
      color: #333;
    }

    h2 {
      background-color: #007bff; /* Couleur revenus du dashboard */
      color: white;
      padding: 20px;
      margin: 0;
      text-align: center;
      font-size: 24px;
    }

    .container {
      max-width: 1200px;
      margin: 30px auto;
      padding: 0 20px;
    }

    .card {
      background-color: white;
      border-radius: 10px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      padding: 25px;
      margin-bottom: 30px;
    }

    /* Alertes */
    .alert {
      padding: 15px;
      border-radius: 5px;
      margin-bottom: 20px;
      max-width: 1200px;
      margin: 20px auto;
    }

    .alert-success {
      background-color: #d4edda;
      color: #155724;
      border: 1px solid #c3e6cb;
    }

    /* Formulaires */
    .form-group {
      margin-bottom: 20px;
    }

    label {
      display: block;
      margin-bottom: 8px;
      font-weight: 500;
    }

    input[type="text"],
    input[type="number"],
    input[type="date"],
    select,
    textarea {
      width: 100%;
      padding: 10px 15px;
      border: 1px solid #ddd;
      border-radius: 5px;
      font-size: 15px;
      transition: border 0.3s;
    }

    input:focus,
    select:focus,
    textarea:focus {
      border-color: #007bff;
      outline: none;
      box-shadow: 0 0 0 3px rgba(0,123,255,0.1);
    }

    textarea {
      min-height: 100px;
      resize: vertical;
    }

    /* Boutons */
    .btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: 10px 20px;
      border-radius: 5px;
      text-decoration: none;
      font-weight: 500;
      transition: all 0.2s;
      border: none;
      cursor: pointer;
      font-size: 15px;
      margin : 5px;
    }

    .btn i {
      margin-right: 8px;
    }

    .btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 8px rgba(0,0,0,0.15);
    }

    .btn-primary {
      background-color: #007bff;
      color: white;
    }

    .btn-secondary {
      background-color: #6c757d;
      color: white;
    }

    .btn-danger {
      background-color: #dc3545;
      color: white;
    }

    .btn-sm {
      padding: 8px 12px;
      font-size: 14px;
    }

    .table-responsive {
      overflow-x: auto;
      margin-top: 20px;
    }
    
    /* Tableau */
    table {
      width: 100%;
      border-collapse: collapse;
      margin: 20px 0;
      background: white;
      border-radius: 10px;
      overflow: hidden;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }

    th, td {
      padding: 12px 15px;
      text-align: left;
      border-bottom: 1px solid #ddd;
    }

    th {
      background-color: #007bff;
      color: white;
      font-weight: 500;
    }

    tr:hover {
      background-color: #f5f5f5;
    }

    /* Filtres */
    .filters {
      display: flex;
      flex-wrap: wrap;
      gap: 15px;
      margin-bottom: 20px;
      background: white;
      padding: 15px;
      border-radius: 10px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }

    .filter-group {
      flex: 1;
      min-width: 200px;
    }

    /* Actions */
    .actions {
      display: flex;
      gap: 5px;
    }

    .actions form {
      margin: 0;
    }

    /* Responsive */
    @media (max-width: 768px) {
      .container {
        padding: 0 15px;
      }
      
      th, td {
        padding: 8px 10px;
      }
      
      .filters {
        flex-direction: column;
        gap: 10px;
      }
      
      .actions {
        flex-direction: column;
      }
    }

.alert {
    display: flex;
    align-items: center;
    gap: 10px;
    border: 1px solid transparent;
}
.alert-success {
    color: #155724;
    background-color: #d4edda;
    border-color: #c3e6cb;
}
.alert-danger {
    color: #721c24;
    background-color: #f8d7da;
    border-color: #f5c6cb;
}
.alert-warning {
    color: #856404;
    background-color: #fff3cd;
    border-color: #ffeeba;
}
.alert-info {
    color: #0c5460;
    background-color: #d1ecf1;
    border-color: #bee5eb;
}

  </style>
</head>
<body>

  <h2><i class="fas fa-hand-holding-usd"></i> Gestion des revenus</h2>

  <div class="container">
    <!-- Section d'ajout -->
    <div class="card">
      <h3 style="margin-top: 0; color: #007bff;"><i class="fas fa-plus-circle"></i> Ajouter un revenu</h3>
      
      <form method="POST" action="../index.php/store_revenu">
        <input type="hidden" name="id_receveur" value="<?= $id_receveur ?>">

        <div class="form-group">
          <label><i class="fas fa-tag"></i> Libellé :</label>
          <input type="text" name="libelle_revenu" required placeholder="Libelle du revenu. Salaire du mois de Février 2025">
        </div>

        <div class="form-group">
          <label><i class="fas fa-list"></i> Catégorie :</label>
          <select name="categorie_revenu" required>
            <option>Salaire</option>
            <option>Revenu_activite</option>
            <option>Revenu_passif</option>
            <option>Don</option>
            <option>Aide</option>
            <option>Subvention</option>
            <option>Remboursement</option>
            <option>Rétro commission</option>
            <option>Autre</option>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-search"></i> Source :</label>
          <input type="text" name="source" value="Source inconnu" required placeholder="Précisez le nom de la source de votre revenu. Ex : commission / prestation / salaire ...">
        </div>

        <div class="form-group">
          <label><i class="fas fa-money-bill-wave"></i> Montant (FCFA) :</label>
          <input type="number" name="montant" step="0.01" required>
        </div>

        <div class="form-group">
          <label><i class="fas fa-credit-card"></i> Mode de paiement :</label>
          <select name="mode_paiement" required>
            <option>Espèces</option>              
            <option>Mobile_money</option>              
            <option>Virement</option>
            <option>Chèque</option>
            <option>Autre</option>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-sync-alt"></i> Fréquence :</label>
          <select name="frequence" required>
            <option>Journalière</option>
            <option>Hebdomadaire</option>
            <option>Mensuelle</option>
            <option>Trimestrielle</option>
            <option>Semestrielle</option>
            <option>Annuelle</option>
            <option>Alternative</option>
            <option>Unique</option>
            <option>Ponctuel</option>
            <option>Irrégulier</option>
          </select>
        </div>

        <div class="form-group">
            <label><i class="fas fa-calendar-day"></i> Date du revenu :</label>
            <input type="date" name="date_revenu" value="<?= date('Y-m-d') ?>" required>
        </div>

        <div class="form-group">
          <label><i class="fas fa-info-circle"></i> Statut :</label>
          <select name="statut" required>
            <option>Prévu</option>
            <option>Encaissé</option>
            <option>Annulé</option>
            <option>Actif</option>
            <option>Prévisionnel</option>
            <option>Expiré</option>
            <option>Suspendu</option>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-comment"></i> Commentaires :</label>
          <textarea name="commentaires" value="Par de commentaire" placeholder="Votre commentaire ici"></textarea>
        </div>

        <div class="form-group">
          <label><i class="fas fa-user-tie"></i> Responsable suivi :</label>
          <input type="text" name="responsable_suivi" value="Moi-même" placeholder="Le nom du responsable suivi. Ex : Moi-même, mon épouse/épaoux" required>
        </div>

        <div class="form-group">
          <label><i class="fas fa-file-alt"></i> Justificatif :</label>
          <textarea name="justificatif" value="Listing/Reçu/Facture/Autre" placeholder="Listing/Reçu/Facture/Autre"></textarea>
        </div>

        <div class="form-group">
          <label><i class="fas fa-hashtag"></i> Référence transaction :</label>
          <input type="text" name="reference_transaction" value="Numéro justificatif Listing/Reçu/Facture/Autre" placeholder="Numéro justificatif Listing/Reçu/Facture/Autre">
        </div>

        <div class="form-group">
          <label><i class="fas fa-user"></i> Donneur :</label>
          <select name="id_donneur">
            <?php foreach ($utilisateurs as $u): ?>
              <option value="<?= $u['id_utilisateur'] ?>">
                <?= htmlspecialchars($u['nom']) ?> <?= htmlspecialchars($u['prenom']) ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-wallet"></i> Compte associé :</label>
          <select name="id_compte">
            <?php foreach ($comptes as $c): ?>
              <option value="<?= $c['id_compte'] ?>">
                <?= htmlspecialchars($c['nom_compte']) ?> (<?= number_format($c['solde'], 0, ',', ' ') ?> FCFA)
              </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div>
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Enregistrer
          </button>
          <a href="../index.php/dashboard" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Tableau de bord
          </a>
        </div>
      </form>
    </div>

    <!-- Section liste -->
    <div class="card">
      <h3 style="margin-top: 0; color: #007bff;"><i class="fas fa-list"></i> Liste des revenus</h3>
      
    <div class="table-responsive">
      <table>
        <thead>
          <tr>
            <th><i class="fas fa-tag"></i> Libellé</th>
            <th><i class="fas fa-list"></i> Catégorie</th>
            <th><i class="fas fa-money-bill-wave"></i> Montant</th>
            <th><i class="fas fa-search"></i> Source</th>
            <th><i class="fas fa-credit-card"></i> Mode</th>
            <th><i class="fas fa-sync-alt"></i> Fréquence</th>
            <th><i class="fas fa-calendar-day"></i> Date</th>
            <th><i class="fas fa-info-circle"></i> Statut</th>
            <th><i class="fas fa-cog"></i> Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($revenus as $r): ?>
            <tr>
              <td><?= htmlspecialchars($r['libelle_revenu']) ?></td>
              <td><?= $r['categorie_revenu'] ?></td>
              <td><?= number_format($r['montant'], 0, ',', ' ') ?> FCFA</td>
              <td><?= $r['source'] ?></td>
              <td><?= $r['mode_paiement'] ?></td>
              <td><?= $r['frequence'] ?></td>
              <td><?= $r['date_revenu'] ?></td>
              <td><?= $r['statut'] ?></td>
              <td class="actions">
                <form method="GET" action="../index.php/edit_revenu/<?= $r['id_revenu'] ?>">
                  <button type="submit" class="btn btn-primary btn-sm">
                    <i class="fas fa-edit"></i>
                  </button>
                </form>
                <form method="POST" action="../index.php/delete_revenu/<?= $r['id_revenu'] ?>" onsubmit="return confirm('Supprimer ce revenu ?');">
                  <button type="submit" class="btn btn-danger btn-sm">
                    <i class="fas fa-trash-alt"></i>
                  </button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
     </div>
    </div>
  </div>
</body>
</html>