
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Inscription - BeWise</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="icon" href="favicon.ico" type="../image/x-icon" />
  <!-- END META SECTION -->
  <!-- CSS INCLUDE -->        
  <link rel="stylesheet" type="text/css" id="theme" href="../css/theme-default.css"/>
  <!-- EOF CSS INCLUDE --> 
  
  <style>
    :root {
      --primary: #4361ee;
      --primary-hover: #3a56d4;
      --danger: #f72585;
      --light: #f8f9fa;
      --dark: #212529;
      --gray: #6c757d;
    }

    body {
      font-family: 'Segoe UI', system-ui, sans-serif;
      background-color: #f8fafc;
      margin: 0;
      padding: 0;
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
      color: #2b2d42;
    }

    .register-container {
      width: 100%;
      max-width: 600px;
      padding: 40px;
      background: white;
      border-radius: 12px;
      box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
    }

    .logo {
      color: var(--primary);
      font-size: 2.5rem;
      text-align: center;
      margin-bottom: 15px;
    }

    h2 {
      color: var(--dark);
      margin: 0 0 25px 0;
      font-size: 1.8rem;
      text-align: center;
    }

    .form-grid {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
      gap: 20px;
    }

    .form-group {
      margin-bottom: 15px;
    }

    .form-group label {
      display: block;
      margin-bottom: 8px;
      font-weight: 500;
      color: var(--dark);
      font-size: 0.9rem;
    }

    .form-control {
      width: 100%;
      padding: 12px 15px;
      border: 1px solid #e2e8f0;
      border-radius: 8px;
      font-size: 0.95rem;
      transition: all 0.3s;
    }

    .form-control:focus {
      border-color: var(--primary);
      outline: none;
      box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.15);
    }

    select.form-control {
      appearance: none;
      background-image: url("data:image/svg+xml;charset=UTF-8,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='none' stroke='currentColor' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3e%3cpolyline points='6 9 12 15 18 9'%3e%3c/polyline%3e%3c/svg%3e");
      background-repeat: no-repeat;
      background-position: right 12px center;
      background-size: 16px;
    }

    textarea.form-control {
      min-height: 100px;
      resize: vertical;
    }

    .btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
      width: 100%;
      padding: 12px;
      border-radius: 8px;
      font-weight: 500;
      cursor: pointer;
      transition: all 0.3s;
      text-decoration: none;
      border: none;
      font-size: 1rem;
      margin-top: 20px;
    }

    .btn-primary {
      background-color: var(--primary);
      color: white;
    }

    .btn-primary:hover {
      background-color: var(--primary-hover);
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(67, 97, 238, 0.25);
    }

    .footer-links {
      margin-top: 25px;
      color: var(--dark);
      font-size: 0.9rem;
      text-align: center;
    }

    .footer-links a {
      color: var(--primary);
      text-decoration: none;
      font-weight: 500;
    }

    .footer-links a:hover {
      text-decoration: underline;
    }

    .input-icon {
      position: relative;
    }

    .input-icon i {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      color: var(--dark);
    }

    .input-icon input {
      padding-left: 40px;
    }

    @media (max-width: 768px) {
      .register-container {
        padding: 30px 20px;
        margin: 20px;
      }
      
      .form-grid {
        grid-template-columns: 1fr;
      }
    }
  </style>
</head>
<body>

  <div class="register-container">
    <div class="logo">
      <i class="fas fa-piggy-bank"></i>
    </div>
    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger">
            <?= htmlspecialchars($_SESSION['error']); ?>
            <?php unset($_SESSION['error']); ?>
        </div>
    <?php endif; ?>
    
    <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success">
            <?= htmlspecialchars($_SESSION['success']); ?>
            <?php unset($_SESSION['success']); ?>
        </div>
    <?php endif; ?>        
    <h2>Créer un compte BeWise</h2>
    
    <form method="POST" action="../index.php/store">
      <div class="form">
        <div class="form-group">
          <label>Nom</label>
          <input type="text" name="nom" class="form-control" required placeholder="Votre nom">
        </div>
        
        <div class="form-group">
          <label>Prénom</label>
          <input type="text" name="prenom" class="form-control" required placeholder="Votre prénom">
        </div>
        
        <div class="form-group input-icon">
          <label>Téléphone</label>
          <i class="fas fa-phone"></i>
          <input type="number" name="email" class="form-control" required placeholder="Votre numéro de téléphone">
        </div>
        
        <div class="form-group input-icon">
          <label>Mot de passe</label>
          <i class="fas fa-lock"></i>
          <input type="password" name="password" class="form-control" required placeholder="••••••••">
        </div>
        
        <div class="form-group">
          <label>Genre</label>
          <select name="genre" class="form-control" required>
            <option value="Masculin">Masculin</option>
            <option value="Féminin">Féminin</option>
          </select>
        </div>
        
        <div class="form-group">
          <label>Date de naissance</label>
          <input type="date" name="date_naissance" class="form-control" required>
        </div>
        
        <div class="form-group">
          <label>Niveau d'éducation</label>
          <input type="text" name="niveau_education" class="form-control" placeholder="Votre niveau d'études" required>
        </div>
        
        <div class="form-group">
          <label>Profession</label>
          <input type="text" name="profession" class="form-control" placeholder="Votre profession" required>
        </div>
        
        <div class="form-group">
          <label>Type utilisateur</label>
          <select name="type_utilisateur" class="form-control">
            <option value="simple">Simple utilisateur</option>
            <option value="admin">Administrateur</option>
            <option value="analyste">Analyste</option>
          </select>
        </div>
        
        <div class="form-group" style="grid-column: span 2;">
          <label>Motivation financière</label>
          <textarea name="motivation_financiere" class="form-control" placeholder="Décrivez vos motivations financières..."></textarea>
        </div>
        
        <div class="form-group">
          <label>Profil de risque</label>
          <select name="profil_risque" class="form-control">
            <option value="faible">Faible</option>
            <option value="moyen">Moyen</option>
            <option value="élevé">Élevé</option>
          </select>
        </div>
      </div>
      
      <button type="submit" class="btn btn-primary">
        <i class="fas fa-user-plus"></i> S'inscrire
      </button>
    </form>

    <div class="footer-links">
      <p>Votre discipline et liberté financière commence ici !</p>  
      <p>Déjà inscrit ? <a href="../index.php/login">Se connecter</a></p>
    </div>
  </div>
</body>
</html>