<!DOCTYPE html>
<html lang="fr">
<head>
    
  <meta charset="UTF-8">
  <title>Profil utilisateur - BeWise</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  

  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="icon" href="favicon.ico" type="../image/x-icon" />
  <!-- END META SECTION -->
  <!-- CSS INCLUDE -->        
  <link rel="stylesheet" type="text/css" id="theme" href="../css/theme-default.css"/>
  <!-- EOF CSS INCLUDE --> 
  
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4f6f8;
      color: #333;
    }

    h2 {
      background-color: #6c757d; /* Couleur profil du dashboard */
      color: white;
      padding: 20px;
      margin: 0;
      text-align: center;
      font-size: 24px;
    }

    .card-container {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      gap: 20px;
      padding: 30px;
    }

    .card {
      background-color: white;
      border-radius: 10px;
      box-shadow: 0 4px 8px rgba(0,0,0,0.1);
      padding: 30px;
      width: 100%;
      max-width: 600px;
    }

    .profile-info {
      margin-bottom: 25px;
    }

    .profile-info p {
      font-size: 16px;
      margin: 15px 0;
      padding-bottom: 15px;
      border-bottom: 1px solid #eee;
      display: flex;
      justify-content: space-between;
    }

    .profile-info strong {
      color: #6c757d;
      font-weight: 600;
      min-width: 180px;
    }

    .profile-info span {
      text-align: right;
      flex-grow: 1;
    }

    .profile-actions {
      display: flex;
      justify-content: space-between;
      margin-top: 30px;
      gap: 15px;
    }

    .btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 8px;
      text-decoration: none;
      padding: 12px 20px;
      border-radius: 8px;
      font-weight: bold;
      border: none;
      cursor: pointer;
      font-size: 16px;
      transition: all 0.3s;
      flex: 1;
    }

    .btn-primary {
      background-color: #28a745;
      color: white;
    }

    .btn-primary:hover {
      background-color: #218838;
      transform: translateY(-2px);
      box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    }

    .btn-secondary {
      background-color: #6c757d;
      color: white;
    }

    .btn-secondary:hover {
      background-color: #5a6268;
      transform: translateY(-2px);
      box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    }

    footer {
      margin: 30px 0;
      text-align: center;
      color: #888;
      font-size: 14px;
    }

    @media (max-width: 768px) {
      .card {
        padding: 20px;
      }
      
      .profile-info p {
        flex-direction: column;
        gap: 5px;
      }
      
      .profile-info strong {
        min-width: auto;
      }
      
      .profile-info span {
        text-align: left;
      }
      
      .profile-actions {
        flex-direction: column;
      }
    }
  </style>
</head>
<body>
  <h2><i class="fas fa-user-circle"></i> Mon Profil</h2>

  <div class="card-container">
    <div class="card">
      <div class="profile-info">
        <?php $u = $_SESSION['user']; ?>
        <p>
          <strong><i class="fas fa-user"></i> Nom complet :</strong>
          <span><?= htmlspecialchars($u['nom'] . ' ' . $u['prenom']) ?></span>
        </p>
        <p>
          <strong><i class="fas fa-phone"></i> Téléphone :</strong>
          <span><?= htmlspecialchars($u['email']) ?></span>
        </p>
        <p>
          <strong><i class="fas fa-venus-mars"></i> Genre :</strong>
          <span><?= htmlspecialchars($u['genre']) ?></span>
        </p>
        <p>
          <strong><i class="fas fa-birthday-cake"></i> Date de naissance :</strong>
          <span><?= htmlspecialchars($u['date_naissance']) ?></span>
        </p>
        <p>
          <strong><i class="fas fa-graduation-cap"></i> Niveau d'éducation :</strong>
          <span><?= htmlspecialchars($u['niveau_education']) ?></span>
        </p>
        <p>
          <strong><i class="fas fa-briefcase"></i> Profession :</strong>
          <span><?= htmlspecialchars($u['profession']) ?></span>
        </p>
        <p>
          <strong><i class="fas fa-user-tag"></i> Type utilisateur :</strong>
          <span><?= htmlspecialchars($u['type_utilisateur']) ?></span>
        </p>
        <p>
          <strong><i class="fas fa-money-bill-wave"></i> Motivation financière :</strong>
          <span><?= htmlspecialchars($u['motivation_financiere']) ?></span>
        </p>
        <p>
          <strong><i class="fas fa-chart-line"></i> Profil de risque :</strong>
          <span><?= htmlspecialchars($u['profil_risque']) ?></span>
        </p>
        <p>
          <strong><i class="fas fa-star"></i> Score de fidélité :</strong>
          <span><?= htmlspecialchars($u['score_fidelite']) ?></span>
        </p>
      </div>

      <div class="profile-actions">
        <a href="../index.php/modifier_profil" class="btn btn-primary">
          <i class="fas fa-edit"></i> Modifier
        </a>
        <a href="../index.php/dashboard" class="btn btn-secondary">
          <i class="fas fa-arrow-left"></i> Retour
        </a>
      </div>
    </div>
  </div>

  <footer>
    Discipline et liberté financière : la voie vers la richesse.
  </footer>
</body>
</html>