<!DOCTYPE html>
<html lang="fr">
<head>

  <title>Connexion - BeWise</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="icon" href="favicon.ico" type="../image/x-icon" />
  <!-- END META SECTION -->
  <!-- CSS INCLUDE -->        
  <link rel="stylesheet" type="text/css" id="theme" href="../css/theme-default.css"/>
  <!-- EOF CSS INCLUDE -->   
  
  <style>
    :root {
      --primary: #4361ee;
      --primary-hover: #3a56d4;
      --danger: #f72585;
      --light: #f8f9fa;
      --dark: #212529;
      --gray: #6c757d;
    }

    body {
      font-family: 'Segoe UI', system-ui, sans-serif;
      background-color: #f8fafc;
      margin: 0;
      padding: 0;
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
      color: #2b2d42;
    }

    .login-container {
      width: 100%;
      max-width: 400px;
      padding: 40px;
      background: white;
      border-radius: 12px;
      box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
      text-align: center;
    }

    .logo {
      color: var(--primary);
      font-size: 2.5rem;
      margin-bottom: 15px;
    }

    h2 {
      color: var(--dark);
      margin: 0 0 25px 0;
      font-size: 1.8rem;
    }

    .alert-error {
      background-color: #f8d7da;
      color: #721c24;
      padding: 12px 15px;
      border-radius: 8px;
      margin-bottom: 20px;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
    }

    .alert-error i {
      font-size: 1.2rem;
    }

    .form-group {
      margin-bottom: 20px;
      text-align: left;
    }

    .form-group label {
      display: block;
      margin-bottom: 8px;
      font-weight: 500;
      color: var(--dark);
    }

    .form-control {
      width: 100%;
      padding: 12px 15px;
      border: 1px solid #e2e8f0;
      border-radius: 8px;
      font-size: 1rem;
      transition: all 0.3s;
    }

    .form-control:focus {
      border-color: var(--primary);
      outline: none;
      box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.15);
    }

    .btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
      width: 100%;
      padding: 12px;
      border-radius: 8px;
      font-weight: 500;
      cursor: pointer;
      transition: all 0.3s;
      text-decoration: none;
      border: none;
      font-size: 1rem;
      margin-top: 10px;
    }

    .btn-primary {
      background-color: var(--primary);
      color: white;
    }

    .btn-primary:hover {
      background-color: var(--primary-hover);
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(67, 97, 238, 0.25);
    }

    .footer-links {
      margin-top: 25px;
      color: var(--gray);
      font-size: 0.9rem;
    }

    .footer-links a {
      color: var(--primary);
      text-decoration: none;
      font-weight: 500;
    }

    .footer-links a:hover {
      text-decoration: underline;
    }

    .input-icon {
      position: relative;
    }

    .input-icon i {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      color: var(--gray);
    }

    .input-icon input {
      padding-left: 40px;
    }

    @media (max-width: 480px) {
      .login-container {
        padding: 30px 20px;
        margin: 20px;
      }
    }
  </style>
</head>
<body>
  <div class="login-container">
    <div class="logo">
      <i class="fas fa-piggy-bank"></i>
    </div>
    <h2>Connexion à BeWise</h2>
    
    <?php @session_start(); if (isset($_SESSION['error'])): ?>
      <div class="alert-error">
        <i class="fas fa-exclamation-circle"></i>
        <?= $_SESSION['error']; unset($_SESSION['error']); ?>
      </div>
    <?php endif; ?>

    <form method="POST" action="../index.php/authenticate">
      <div class="form-group input-icon">
        <label for="email">Télephone</label>
        <i class="fas fa-phone"></i>
        <input type="number" id="email" name="email" class="form-control" required placeholder="Votre numero de téléphone">
      </div>
      
      <div class="form-group input-icon">
        <label for="mot_de_passe">Mot de passe</label>
        <i class="fas fa-lock"></i>
        <input type="password" id="mot_de_passe" name="password" class="form-control" required placeholder="••••••••">
      </div>
      
      <button type="submit" class="btn btn-primary">
        <i class="fas fa-sign-in-alt"></i> Se connecter
      </button>
    </form>

    <div class="footer-links">
      <p>Votre discipline et liberté financière commence ici !</p>  
      <p>Pas encore inscrit ? <a href="../index.php/register">Créer un compte</a></p>
      <p><a href="../index.php/forgot-password">Mot de passe oublié ?</a></p>
    </div>
  </div>
</body>
</html>