<?php
// Déplacer cette ligne tout en haut, avant tout code HTML
if (session_status() === PHP_SESSION_NONE) @session_start();

if (isset($_SESSION['flash'])) {
    $flashType = $_SESSION['flash']['type'];
    $flashMessage = $_SESSION['flash']['message'];
    unset($_SESSION['flash']);
    
    $alertClass = '';
    $icon = '';
    
    switch ($flashType) {
        case 'success':
            $alertClass = 'alert-success';
            $icon = 'fa-check-circle';
            break;
        case 'danger':
            $alertClass = 'alert-danger';
            $icon = 'fa-exclamation-circle';
            break;
        case 'warning':
            $alertClass = 'alert-warning';
            $icon = 'fa-exclamation-triangle';
            break;
        default:
            $alertClass = 'alert-info';
            $icon = 'fa-info-circle';
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Modifier un revenu lié à un bien - Gespes360</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  
  <style>
    /* Styles cohérents avec le dashboard */
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4f6f8;
      color: #333;
    }

    h2 {
      background-color: #20c997;
      color: white;
      padding: 20px;
      margin: 0;
      text-align: center;
      font-size: 24px;
    }

    .container {
      max-width: 1000px;
      margin: 30px auto;
      padding: 0 20px;
    }

    .card {
      background-color: white;
      border-radius: 10px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      padding: 25px;
      margin-bottom: 30px;
    }

    /* Alertes */
    .alert {
      padding: 15px;
      border-radius: 5px;
      margin-bottom: 20px;
      display: flex;
      align-items: center;
      gap: 10px;
      border: 1px solid transparent;
    }

    .alert-danger {
      color: #721c24;
      background-color: #f8d7da;
      border-color: #f5c6cb;
    }

    /* Formulaires */
    .form-group {
      margin-bottom: 20px;
    }

    label {
      display: block;
      margin-bottom: 8px;
      font-weight: 500;
    }

    input[type="text"],
    input[type="number"],
    input[type="date"],
    select,
    textarea {
      width: 100%;
      padding: 10px 15px;
      border: 1px solid #ddd;
      border-radius: 5px;
      font-size: 15px;
      transition: border 0.3s;
    }

    input:focus,
    select:focus,
    textarea:focus {
      border-color: #20c997;
      outline: none;
      box-shadow: 0 0 0 3px rgba(32,201,151,0.1);
    }

    textarea {
      min-height: 100px;
      resize: vertical;
    }

    /* Boutons */
    .btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: 10px 20px;
      border-radius: 5px;
      text-decoration: none;
      font-weight: 500;
      transition: all 0.2s;
      border: none;
      cursor: pointer;
      font-size: 15px;
      margin: 5px;
    }

    .btn i {
      margin-right: 8px;
    }

    .btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 8px rgba(0,0,0,0.15);
    }

    .btn-primary {
      background-color: #20c997;
      color: white;
    }

    .btn-secondary {
      background-color: #6c757d;
      color: white;
    }

    /* Responsive */
    @media (max-width: 768px) {
      .container {
        padding: 0 15px;
      }
    }
  </style>
</head>
<body>

  <h2><i class="fas fa-edit"></i> Modifier un revenu lié à un bien</h2>

  <div class="container">
    <div class="card">
      <?php if (isset($alertClass)): ?>
        <div class="alert <?= $alertClass ?>">
          <i class="fas <?= $icon ?>"></i> <?= $flashMessage ?>
        </div>
      <?php endif; ?>

      <?php if (!isset($biens)): ?>
        <div class="alert alert-danger"><i class="fas fa-exclamation-circle"></i> La variable $biens n'est pas définie.</div>
      <?php elseif (empty($biens)): ?>
        <div class="alert alert-danger"><i class="fas fa-exclamation-circle"></i> Aucun bien trouvé pour cet utilisateur.</div>
      <?php endif; ?>

      <form method="POST" action="../update_revenus_biens/<?= $revenu['id_revenus_biens'] ?>">
        <div class="form-group">
          <label><i class="fas fa-home"></i> Bien concerné :</label>
          <select name="id_bien" required>
            <option value="">-- Sélectionner un bien --</option>
            <?php foreach ($biens as $b): ?>
              <option value="<?= $b['id_bien'] ?>" <?= ($b['id_bien'] == $revenu['id_bien']) ? 'selected' : '' ?>>
                <?= htmlspecialchars($b['libelle_bien']) ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-tag"></i> Libellé du revenu :</label>
          <input type="text" name="libelle_revenu_bien" value="<?= htmlspecialchars($revenu['libelle_revenu_bien']) ?>" required>
        </div>

        <div class="form-group">
          <label><i class="fas fa-money-bill-wave"></i> Montant du revenu :</label>
          <input type="number" name="montant_revenu" step="0.01" value="<?= $revenu['montant_revenu'] ?>" required>
        </div>

        <div class="form-group">
          <label><i class="fas fa-list"></i> Type de revenu :</label>
          <input type="text" name="type_revenu_bien" value="<?= htmlspecialchars($revenu['type_revenu_bien']) ?>">
        </div>

        <div class="form-group">
          <label><i class="fas fa-search"></i> Origine du revenu :</label>
          <input type="text" name="origine_revenu" value="<?= htmlspecialchars($revenu['origine_revenu']) ?>">
        </div>

        <div class="form-group">
          <label><i class="fas fa-sync-alt"></i> Fréquence :</label>
          <select name="frequence">
            <?php
              $frequences = ['Mensuelle','Trimestrielle','Annuelle'];
              foreach ($frequences as $f) {
                $selected = ($revenu['frequence'] === $f) ? 'selected' : '';
                echo "<option $selected>$f</option>";
              }
            ?>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-user-tie"></i> Responsable de la collecte :</label>
          <input type="text" name="responsable_collecte" value="<?= htmlspecialchars($revenu['responsable_collecte']) ?>">
        </div>

        <div class="form-group">
          <label><i class="fas fa-file-alt"></i> Justificatif :</label>
          <textarea name="justificatif"><?= htmlspecialchars($revenu['justificatif']) ?></textarea>
        </div>

        <div class="form-group">
          <label><i class="fas fa-calendar-alt"></i> Mois :</label>
          <select name="mois_revenu">
            <?php
              $mois = ['Janvier','Février','Mars','Avril','Mai','Juin','Juillet','Août','Septembre','Octobre','Novembre','Décembre'];
              foreach ($mois as $m) {
                $selected = ($revenu['mois_revenu'] === $m) ? 'selected' : '';
                echo "<option $selected>$m</option>";
              }
            ?>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-calendar"></i> Année :</label>
          <select name="annee_revenu" required>
            <?php
              for ($year = 2025; $year <= 2055; $year++) {
                $selected = ($revenu['annee_revenu'] == $year) ? 'selected' : '';
                echo "<option value='$year' $selected>$year</option>";
              }
            ?>
          </select>
        </div>

        <div>
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Enregistrer les modifications
          </button>
          <a href="../revenus_biens" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Annuler
          </a>
        </div>
      </form>
    </div>
  </div>
</body>
</html>