<?php if (session_status() === PHP_SESSION_NONE) session_start(); ?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Modifier un revenu - BeWise</title>
  <style>
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      padding: 0;
      margin: 0;
      background-color: #f4f6f8;
      color: #333;
    }
    
    h2 {
      background-color: #007bff;
      color: white;
      padding: 20px;
      margin: 0;
      text-align: center;
      font-size: 24px;
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    
    .container {
      max-width: 1000px;
      margin: 30px auto;
      padding: 0 20px;
    }
    
    .card {
      background-color: white;
      border-radius: 10px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      padding: 25px;
      margin-bottom: 30px;
    }
    
    label {
      display: block;
      margin-bottom: 8px;
      font-weight: 500;
      color: #495057;
    }
    
    input[type="text"],
    input[type="number"],
    input[type="date"],
    select,
    textarea {
      width: 100%;
      padding: 10px 15px;
      border: 1px solid #ddd;
      border-radius: 5px;
      font-size: 15px;
      margin-bottom: 15px;
      transition: border 0.3s;
    }
    
    input:focus,
    select:focus,
    textarea:focus {
      border-color: #20c997;
      outline: none;
      box-shadow: 0 0 0 3px rgba(32,201,151,0.1);
    }
    
    textarea {
      min-height: 100px;
      resize: vertical;
    }
    
    .btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: 10px 20px;
      border-radius: 5px;
      text-decoration: none;
      font-weight: 500;
      transition: all 0.2s;
      border: none;
      cursor: pointer;
      font-size: 15px;
      margin: 5px;
    }
    
    .btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 8px rgba(0,0,0,0.15);
    }
    
    .btn-primary {
      background-color: #007bff;
      color: white;
    }
    
    .btn-secondary {
      background-color: #6c757d;
      color: white;
    }
    
    .alert {
      padding: 15px;
      border-radius: 5px;
      margin-bottom: 20px;
      display: flex;
      align-items: center;
      gap: 10px;
      border: 1px solid transparent;
    }
    
    .alert-danger {
      color: #721c24;
      background-color: #f8d7da;
      border-color: #f5c6cb;
    }
    
    @media (max-width: 768px) {
      .container {
        padding: 0 15px;
      }
    }
  </style>
</head>
<body>

<h2>Modifier un revenu</h2>

<div class="container">
  <div class="card">
    <form method="POST" action="../update_revenu/<?= $revenu['id_revenu'] ?>">
      <input type="hidden" name="id_receveur" value="<?= $_SESSION['user']['id_utilisateur'] ?>">

      <label>Libellé :</label>
      <input type="text" name="libelle_revenu" value="<?= htmlspecialchars($revenu['libelle_revenu']) ?>" required>

      <label>Catégorie :</label>
      <select name="categorie_revenu">
        <?php
          $categories = ['Salaire','Revenu_activite','Revenu_passif','Don','Aide','Subvention','Remboursement','Rétro commission','Autre'];
          foreach ($categories as $cat) {
            $selected = ($revenu['categorie_revenu'] === $cat) ? 'selected' : '';
            echo "<option $selected>$cat</option>";
          }
        ?>
      </select>

      <label>Source :</label>
      <input type="text" name="source" value="<?= htmlspecialchars($revenu['source']) ?>">

      <label>Montant :</label>
      <input type="number" name="montant" step="0.01" value="<?= $revenu['montant'] ?>" required>

      <label>Mode de paiement :</label>
      <select name="mode_paiement">
        <?php
          $modes = ['Virement','Espèces','Chèque','Mobile_money','Autre'];
          foreach ($modes as $mode) {
            $selected = ($revenu['mode_paiement'] === $mode) ? 'selected' : '';
            echo "<option $selected>$mode</option>";
          }
        ?>
      </select>

      <label>Fréquence :</label>
      <select name="frequence">
        <?php
          $frequences = ['Journalière','Hebdomadaire','Mensuelle','Trimestrielle','Semestrielle','Annuelle','Alternative','Unique','Ponctuel','Irrégulier'];
          foreach ($frequences as $freq) {
            $selected = ($revenu['frequence'] === $freq) ? 'selected' : '';
            echo "<option $selected>$freq</option>";
          }
        ?>
      </select>

      <label>Date du revenu :</label>
      <input type="date" name="date_revenu" value="<?= $revenu['date_revenu'] ?>">

      <label>Statut :</label>
      <select name="statut">
        <?php
          $statuts = ['Prévu','Encaissé','Annulé','Actif','Prévisionnel','Expiré','Suspendu'];
          foreach ($statuts as $s) {
            $selected = ($revenu['statut'] === $s) ? 'selected' : '';
            echo "<option $selected>$s</option>";
          }
        ?>
      </select>

      <label>Commentaires :</label>
      <textarea name="commentaires"><?= htmlspecialchars($revenu['commentaires']) ?></textarea>

      <label>Responsable suivi :</label>
      <input type="text" name="responsable_suivi" value="<?= htmlspecialchars($revenu['responsable_suivi']) ?>">

      <label>Justificatif :</label>
      <textarea name="justificatif"><?= htmlspecialchars($revenu['justificatif']) ?></textarea>

      <label>Référence transaction :</label>
      <input type="text" name="reference_transaction" value="<?= htmlspecialchars($revenu['reference_transaction']) ?>">

      <label>Donneur :</label>
      <select name="id_donneur">
        <?php foreach ($utilisateurs as $u): ?>
          <option value="<?= $u['id_utilisateur'] ?>" <?= $revenu['id_donneur'] == $u['id_utilisateur'] ? 'selected' : '' ?>>
            <?= htmlspecialchars($u['nom']) ?> <?= htmlspecialchars($u['prenom']) ?>
          </option>
        <?php endforeach; ?>
      </select>

      <label>Compte associé :</label>
      <select name="id_compte">
        <?php foreach ($comptes as $c): ?>
          <option value="<?= $c['id_compte'] ?>" <?= $revenu['id_compte'] == $c['id_compte'] ? 'selected' : '' ?>>
            <?= htmlspecialchars($c['nom_compte']) ?> (<?= number_format($c['solde'], 0, ',', ' ') ?> FCFA)
          </option>
        <?php endforeach; ?>
      </select>

      <button type="submit" class="btn btn-primary">Enregistrer les modifications</button>
      <a href="../revenus" class="btn btn-secondary">Annuler</a>
    </form>
  </div>
</div>
</body>
</html>