<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Modifier un financement d'épargne - Gespes360</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" href="favicon.ico" type="../image/x-icon" />
    <!-- CSS INCLUDE -->        
    <link rel="stylesheet" type="text/css" id="theme" href="../../css/theme-default.css"/>
    <style>
        /* Styles cohérents avec le dashboard */
        body {
            margin: 0;
            font-family: 'Segoe UI', sans-serif;
            background-color: #f4f6f8;
            color: #333;
        }

        h1 {
            background-color: #198754;
            color: white;
            padding: 20px;
            margin: 0 0 20px 0;
            text-align: center;
            font-size: 24px;
        }

        .container {
            max-width: 1000px;
            margin: 0 auto 30px auto;
            padding: 0 20px;
        }

        .card {
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            padding: 25px;
            margin-bottom: 30px;
        }

        /* Alertes */
        .alert {
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .alert-success {
            color: #155724;
            background-color: #d4edda;
            border-color: #c3e6cb;
        }

        /* Formulaires */
        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
        }

        input[type="text"],
        input[type="number"],
        input[type="date"],
        input[type="time"],
        select,
        textarea {
            width: 100%;
            padding: 10px 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 15px;
            transition: border 0.3s;
        }

        textarea {
            min-height: 100px;
        }

        input:focus,
        select:focus,
        textarea:focus {
            border-color: #343a40;
            outline: none;
            box-shadow: 0 0 0 3px rgba(52,58,64,0.1);
        }

        /* Boutons */
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 10px 20px;
            border-radius: 5px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.2s;
            border: none;
            cursor: pointer;
            font-size: 15px;
            margin: 5px;
        }

        .btn i {
            margin-right: 8px;
        }

        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
        }

        .btn-primary {
            background-color: #198754;
            color: white;
        }

        .btn-secondary {
            background-color: #6c757d;
            color: white;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .container {
                padding: 0 15px;
            }
            
            .btn {
                width: 100%;
                margin: 5px 0;
            }
        }
    </style>
</head>
<body>
    <h1><i class="fas fa-piggy-bank"></i> Modifier le financement d'épargne #<?= $financement['id_epargner'] ?></h1>

    <?php if (isset($_GET['success']) && $_GET['success'] == '1'): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> Modification enregistrée avec succès.
        </div>
    <?php endif; ?>

    <div class="container">
        <div class="card">
            <form action="../update_financement_epargne/<?= $financement['id_epargner'] ?>" method="POST">
                <div class="form-group">
                    <label><i class="fas fa-tag"></i> Libellé :</label>
                    <input type="text" name="libelle_epargner" value="<?= htmlspecialchars($financement['libelle_epargner']) ?>" required>
                </div>

                <div class="form-group">
                    <label><i class="fas fa-coins"></i> Montant :</label>
                    <input type="number" name="montant" step="0.01" value="<?= $financement['montant'] ?>" required>
                </div>

                <div class="form-group">
                    <label><i class="fas fa-bullseye"></i> Épargne cible :</label>
                    <select name="id_epargne_ct" required>
                        <?php foreach ($epargnes as $e): ?>
                            <option value="<?= $e['id_epargne_ct'] ?>" <?= $financement['id_epargne_ct'] == $e['id_epargne_ct'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($e['libelle_epargne']) ?> (<?= number_format($e['montant_actuel'], 0, ',', ' ') ?> FCFA)
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label><i class="fas fa-money-bill-trend-up"></i> Revenu :</label>
                    <select name="id_revenu">
                        <option value="">-- Aucun --</option>
                        <?php foreach ($revenus as $r): ?>
                            <option value="<?= $r['id_revenu'] ?>" <?= $financement['id_revenu'] == $r['id_revenu'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($r['libelle_revenu']) ?> (<?= number_format($r['montant'], 0, ',', ' ') ?> FCFA)
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label><i class="fas fa-hand-holding-dollar"></i> Gain :</label>
                    <select name="id_gain">
                        <option value="">-- Aucun --</option>
                        <?php foreach ($gains as $g): ?>
                            <option value="<?= $g['id_gain'] ?>" <?= $financement['id_gain'] == $g['id_gain'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($g['libelle_gain']) ?> (<?= number_format($g['montant_gain'], 0, ',', ' ') ?> FCFA)
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label><i class="fas fa-calendar-day"></i> Date :</label>
                    <input type="date" name="date_epargne" value="<?= $financement['date_epargne'] ?>">
                </div>

                <div class="form-group">
                    <label><i class="fas fa-clock"></i> Heure :</label>
                    <input type="time" name="heure_epargne" value="<?= $financement['heure_epargne'] ?>">
                </div>

                <div class="form-group">
                    <label><i class="fas fa-search"></i> Origine des fonds :</label>
                    <input type="text" name="origine_fonds" value="<?= htmlspecialchars($financement['origine_fonds']) ?>">
                </div>

                <div class="form-group">
                    <label><i class="fas fa-exchange-alt"></i> Moyen de transfert :</label>
                    <input type="text" name="moyen_transfer" value="<?= htmlspecialchars($financement['moyen_transfer']) ?>">
                </div>

                <div class="form-group">
                    <label><i class="fas fa-file-alt"></i> Justificatif de dépôt :</label>
                    <textarea name="justificatif_depot"><?= htmlspecialchars($financement['justificatif_depot']) ?></textarea>
                </div>

                <div class="form-group">
                    <label><i class="fas fa-user-tie"></i> Responsable :</label>
                    <input type="text" name="responsable_enregistrement" value="<?= htmlspecialchars($financement['responsable_enregistrement']) ?>">
                </div>

                <div class="form-group">
                    <label><i class="fas fa-lightbulb"></i> Note stratégique :</label>
                    <textarea name="note_strategique"><?= htmlspecialchars($financement['note_strategique']) ?></textarea>
                </div>

                <div>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Enregistrer les modifications
                    </button>
                    <a href="../financements_epargnes" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Retour à la liste
                    </a>
                </div>
            </form>
        </div>
    </div>
</body>
</html>