<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Modifier une épargne CT - BeWise</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="icon" href="favicon.ico" type="../image/x-icon" />
  <!-- CSS INCLUDE -->        
  <link rel="stylesheet" type="text/css" id="theme" href="../../css/theme-default.css"/>
  <style>
    /* Styles cohérents avec le dashboard */
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4f6f8;
      color: #333;
    }

    h2 {
      background-color: #28a745;
      color: white;
      padding: 20px;
      margin: 0;
      text-align: center;
      font-size: 24px;
    }

    .container {
      max-width: 800px;
      margin: 30px auto;
      padding: 0 20px;
    }

    .card {
      background-color: white;
      border-radius: 10px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      padding: 25px;
      margin-bottom: 30px;
    }

    /* Formulaires */
    .form-group {
      margin-bottom: 20px;
    }

    label {
      display: block;
      margin-bottom: 8px;
      font-weight: 500;
    }

    input[type="text"],
    input[type="number"],
    input[type="date"],
    input[type="hidden"],
    select,
    textarea {
      width: 100%;
      padding: 10px 15px;
      border: 1px solid #ddd;
      border-radius: 5px;
      font-size: 15px;
      transition: border 0.3s;
      margin-bottom: 10px;
    }

    textarea {
      min-height: 100px;
    }

    input:focus,
    select:focus,
    textarea:focus {
      border-color: #6610f2;
      outline: none;
      box-shadow: 0 0 0 3px rgba(102,16,242,0.1);
    }

    /* Boutons */
    .btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: 10px 20px;
      border-radius: 5px;
      text-decoration: none;
      font-weight: 500;
      transition: all 0.2s;
      border: none;
      cursor: pointer;
      font-size: 15px;
      margin: 5px;
    }

    .btn i {
      margin-right: 8px;
    }

    .btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 8px rgba(0,0,0,0.15);
    }

    .btn-primary {
      background-color: #28a745;
      color: white;
    }

    .btn-secondary {
      background-color: #6c757d;
      color: white;
    }

    /* Lien retour */
    .back-link {
      display: inline-block;
      margin-top: 15px;
      color: #6610f2;
      text-decoration: none;
      font-weight: 500;
    }

    /* Responsive */
    @media (max-width: 768px) {
      .container {
        padding: 0 15px;
      }
      
      .btn {
        width: 100%;
        margin: 5px 0;
      }
    }
  </style>
</head>
<body>
  <?php
    if (session_status() === PHP_SESSION_NONE) @session_start();
    $id_utilisateur = $_SESSION['user']['id_utilisateur'];
  ?>

  <h2><i class="fas fa-piggy-bank"></i> Modifier une épargne CT</h2>

  <div class="container">
    <div class="card">
      <form method="POST" action="../update_epargne_ct/<?= $epargne['id_epargne_ct'] ?>">
        <input type="hidden" name="id_utilisateur" value="<?= $id_utilisateur ?>">

        <div class="form-group">
          <label><i class="fas fa-tag"></i> Libellé :</label>
          <input type="text" name="libelle_epargne" value="<?= htmlspecialchars($epargne['libelle_epargne']) ?>" required>
        </div>

        <div class="form-group">
          <label><i class="fas fa-bullseye"></i> Objectif :</label>
          <input type="text" name="objectif" value="<?= htmlspecialchars($epargne['objectif']) ?>" required>
        </div>

        <div class="form-group">
          <label><i class="fas fa-list"></i> Type d'épargne :</label>
          <select name="type_epargne">
            <?php
              $types = ['Épargne structurelle','Constitution capitale','Fonds d\'urgence','Stabilisation budgetaire','Épargne projetée','Objectif achat','Objectif etudes','Objectif evenement','Épargne stratégique','Investissement financier','Plan retraite','Optimisation fiscale','Épargne comportementale','Challenge personnel','Auto recompense','Coffre silencieux','Épargne institutionnelle','Plan epargne employeur','Plan epargne associe','Epargne mutualisée','Épargne technique ou simulée','Epargne virtuel','Epargne atteinte','Autre 1','Autre 2','Autre 3','Autre 4','Autre 5','Autre 6','Autre 7','Aucun','biens_existant'];
              foreach ($types as $type) {
                $selected = ($epargne['type_epargne'] === $type) ? 'selected' : '';
                echo "<option value=\"$type\" $selected>$type</option>";
              }
            ?>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-wallet"></i> Compte associé :</label>
          <select name="id_compte" required>
            <?php foreach ($comptes as $c): ?>
              <option value="<?= $c['id_compte'] ?>" <?= $epargne['id_compte'] == $c['id_compte'] ? 'selected' : '' ?>>
                <?= htmlspecialchars($c['nom_compte']) ?> (<?= $c['type_compte'] ?> - <?= $c['devise'] ?>)
              </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-exclamation-triangle"></i> Priorité :</label>
          <select name="priorite">
            <option value="haute" <?= $epargne['priorite'] === 'haute' ? 'selected' : '' ?>>haute</option>
            <option value="moyenne" <?= $epargne['priorite'] === 'moyenne' ? 'selected' : '' ?>>moyenne</option>
            <option value="basse" <?= $epargne['priorite'] === 'basse' ? 'selected' : '' ?>>basse</option>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-info-circle"></i> Statut :</label>
          <select name="statut">
            <option value="en_cours" <?= $epargne['statut'] === 'en_cours' ? 'selected' : '' ?>>en cours</option>
            <option value="atteint" <?= $epargne['statut'] === 'atteint' ? 'selected' : '' ?>>atteint</option>
            <option value="reporté" <?= $epargne['statut'] === 'reporté' ? 'selected' : '' ?>>reporté</option>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-money-bill-wave"></i> Montant visé :</label>
          <input type="number" name="montant_vise" step="0.01" value="<?= $epargne['montant_vise'] ?>" required>
        </div>

        <div class="form-group">
          <label><i class="fas fa-coins"></i> Montant actuel :</label>
          <input type="number" name="montant_actuel" step="0.01" value="<?= $epargne['montant_actuel'] ?>" required>
        </div>

        <div class="form-group">
          <label><i class="fas fa-calendar-day"></i> Date d'échéance :</label>
          <input type="date" name="date_echeance" value="<?= $epargne['date_echeance'] ?>" required>
        </div>

        <div class="form-group">
          <label><i class="fas fa-comment"></i> Commentaire :</label>
          <textarea name="commentaire"><?= htmlspecialchars($epargne['commentaire']) ?></textarea>
        </div>

        <div>
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Mettre à jour
          </button>
          <a href="../epargne_ct" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Retour à la liste
          </a>
        </div>
      </form>
    </div>
  </div>
</body>
</html>