<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title><?= isset($dette) ? 'Modifier une dette' : 'Ajouter une dette' ?> - Gespes360</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="icon" href="favicon.ico" type="../image/x-icon" />
  <!-- CSS INCLUDE -->        
  <link rel="stylesheet" type="text/css" id="theme" href="../../css/theme-default.css"/>
  <style>
    /* Styles cohérents avec le dashboard */
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4f6f8;
      color: #333;
    }

    h2 {
      background-color: #ffc107;
      color: white;
      padding: 20px;
      margin: 0;
      text-align: center;
      font-size: 24px;
    }

    .container {
      max-width: 1000px;
      margin: 30px auto;
      padding: 0 20px;
    }

    .card {
      background-color: white;
      border-radius: 10px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      padding: 25px;
      margin-bottom: 30px;
    }

    /* Formulaires */
    .form-group {
      margin-bottom: 20px;
    }

    label {
      display: block;
      margin-bottom: 8px;
      font-weight: 500;
    }

    input[type="text"],
    input[type="number"],
    input[type="date"],
    input[type="hidden"],
    select,
    textarea {
      width: 100%;
      padding: 10px 15px;
      border: 1px solid #ddd;
      border-radius: 5px;
      font-size: 15px;
      transition: border 0.3s;
      margin-bottom: 10px;
    }

    textarea {
      min-height: 100px;
    }

    input:focus,
    select:focus,
    textarea:focus {
      border-color: #6610f2;
      outline: none;
      box-shadow: 0 0 0 3px rgba(102,16,242,0.1);
    }

    /* Boutons */
    .btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: 10px 20px;
      border-radius: 5px;
      text-decoration: none;
      font-weight: 500;
      transition: all 0.2s;
      border: none;
      cursor: pointer;
      font-size: 15px;
      margin: 5px;
    }

    .btn i {
      margin-right: 8px;
    }

    .btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 8px rgba(0,0,0,0.15);
    }

    .btn-primary {
      background-color: #ffc107;
      color: white;
    }

    .btn-secondary {
      background-color: #6c757d;
      color: white;
    }

    /* Lien retour */
    .back-link {
      display: inline-block;
      margin-top: 15px;
      color: #6610f2;
      text-decoration: none;
      font-weight: 500;
    }

    .back-link:hover {
      text-decoration: underline;
    }

    /* Responsive */
    @media (max-width: 768px) {
      .container {
        padding: 0 15px;
      }
      
      .btn {
        width: 100%;
        margin: 5px 0;
      }
    }
  </style>
</head>
<body>
  <?php
    if (session_status() === PHP_SESSION_NONE) @session_start();
    $id_utilisateur = $_SESSION['user']['id_utilisateur'];
  ?>

  <h2><i class="fas fa-file-invoice-dollar"></i> <?= isset($dette) ? 'Modifier la dette' : 'Ajouter une nouvelle dette' ?></h2>

  <div class="container">
    <div class="card">
      <form method="POST" action="<?= isset($dette) ? '../update_dette/' . $dette['id_dette'] : '../index.php/store-dette' ?>">
        <input type="hidden" name="id_contracteur" value="<?= $id_utilisateur ?>">

        <div class="form-group">
          <label><i class="fas fa-tag"></i> Libellé :</label>
          <input type="text" name="libelle_dette" value="<?= $dette['libelle_dette'] ?? '' ?>" required>
        </div>

        <div class="form-group">
          <label><i class="fas fa-hand-holding-usd"></i> Montant emprunté :</label>
          <input type="number" name="montant_emprunt" step="0.01" value="<?= $dette['montant_emprunt'] ?? 0 ?>">
        </div>

        <div class="form-group">
          <label><i class="fas fa-money-bill-wave"></i> Montant remboursement :</label>
          <input type="number" name="montant_remboursement" step="0.01" value="<?= $dette['montant_remboursement'] ?? 0 ?>">
        </div>

        <div class="form-group">
          <label><i class="fas fa-percentage"></i> Taux d'intérêt :</label>
          <input type="number" name="taux_d_interest" step="0.01" value="<?= $dette['taux_d_interest'] ?? 0 ?>">
        </div>

        <div class="form-group">
          <label><i class="fas fa-wallet"></i> Compte associé :</label>
          <select name="id_compte">
            <?php foreach ($comptes as $c): ?>
              <option value="<?= $c['id_compte'] ?>" <?= isset($dette) && $dette['id_compte'] == $c['id_compte'] ? 'selected' : '' ?>>
                <?= $c['nom_compte'] ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-user-tie"></i> Octroyeur :</label>
          <select name="id_octroyeur">
            <option value="">-- Aucun --</option>
            <?php foreach ($utilisateurs as $u): ?>
              <option value="<?= $u['id_utilisateur'] ?>" <?= isset($dette) && $dette['id_octroyeur'] == $u['id_utilisateur'] ? 'selected' : '' ?>>
                <?= $u['nom'].' '.$u['prenom'] ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-list"></i> Type de dette :</label>
          <input type="text" name="type_dette" value="<?= $dette['type_dette'] ?? '' ?>">
        </div>

        <div class="form-group">
          <label><i class="fas fa-search"></i> Origine de la dette :</label>
          <textarea name="origine_dette"><?= $dette['origine_dette'] ?? '' ?></textarea>
        </div>

        <div class="form-group">
          <label><i class="fas fa-shield-alt"></i> Garantie :</label>
          <textarea name="garantie"><?= $dette['garantie'] ?? '' ?></textarea>
        </div>

        <div class="form-group">
          <label><i class="fas fa-info-circle"></i> Statut :</label>
          <select name="statut">
            <?php foreach (['active', 'remboursée', 'annulée'] as $statut): ?>
              <option value="<?= $statut ?>" <?= isset($dette) && $dette['statut'] == $statut ? 'selected' : '' ?>><?= ucfirst($statut) ?></option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-exclamation-triangle"></i> Priorité :</label>
          <select name="niveau_priorite">
            <?php foreach (['haute', 'moyenne', 'basse'] as $prio): ?>
              <option value="<?= $prio ?>" <?= isset($dette) && $dette['niveau_priorite'] == $prio ? 'selected' : '' ?>><?= ucfirst($prio) ?></option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-calendar-day"></i> Date emprunt :</label>
          <input type="date" name="date_emprunt" value="<?= $dette['date_emprunt'] ?? '' ?>">
        </div>

        <div class="form-group">
          <label><i class="fas fa-calendar-check"></i> Date remboursement :</label>
          <input type="date" name="date_remboursement" value="<?= $dette['date_remboursement'] ?? '' ?>">
        </div>

        <div class="form-group">
          <label><i class="fas fa-history"></i> Historique des remboursements :</label>
          <textarea name="historique_remboursements"><?= $dette['historique_remboursements'] ?? '' ?></textarea>
        </div>

        <div class="form-group">
          <label><i class="fas fa-align-left"></i> Description :</label>
          <textarea name="description"><?= $dette['description'] ?? '' ?></textarea>
        </div>

        <div>
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> <?= isset($dette) ? 'Enregistrer les modifications' : 'Enregistrer la dette' ?>
          </button>
          <a href="../dettes" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Retour à la liste des dettes
          </a>
        </div>
      </form>
    </div>
  </div>
</body>
</html>