<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Modifier une dépense bien - Gespes360</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="icon" href="favicon.ico" type="../image/x-icon" />
  <!-- END META SECTION -->
  <!-- CSS INCLUDE -->        
  <link rel="stylesheet" type="text/css" id="theme" href="../../css/theme-default.css"/>
  <!-- EOF CSS INCLUDE --> 
  
  <style>
    /* Styles cohérents avec le dashboard */
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4f6f8;
      color: #333;
    }

    h2 {
      background-color: #6610f2;
      color: white;
      padding: 20px;
      margin: 0;
      text-align: center;
      font-size: 24px;
    }

    .container {
      max-width: 1000px;
      margin: 30px auto;
      padding: 0 20px;
    }

    .card {
      background-color: white;
      border-radius: 10px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      padding: 25px;
      margin-bottom: 30px;
    }

    /* Formulaires */
    .form-group {
      margin-bottom: 20px;
    }

    label {
      display: block;
      margin-bottom: 8px;
      font-weight: 500;
    }

    input[type="text"],
    input[type="number"],
    input[type="hidden"],
    select,
    textarea {
      width: 100%;
      padding: 10px 15px;
      border: 1px solid #ddd;
      border-radius: 5px;
      font-size: 15px;
      transition: border 0.3s;
      margin-bottom: 10px;
    }

    textarea {
      min-height: 100px;
    }

    input:focus,
    select:focus,
    textarea:focus {
      border-color: #6610f2;
      outline: none;
      box-shadow: 0 0 0 3px rgba(102,16,242,0.1);
    }

    /* Alertes */
    .alert {
      padding: 15px;
      margin-bottom: 20px;
      border-radius: 5px;
      color: #721c24;
      background-color: #f8d7da;
      border-color: #f5c6cb;
    }

    /* Boutons */
    .btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: 10px 20px;
      border-radius: 5px;
      text-decoration: none;
      font-weight: 500;
      transition: all 0.2s;
      border: none;
      cursor: pointer;
      font-size: 15px;
      margin: 5px;
    }

    .btn i {
      margin-right: 8px;
    }

    .btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 8px rgba(0,0,0,0.15);
    }

    .btn-primary {
      background-color: #6610f2;
      color: white;
    }

    .btn-secondary {
      background-color: #6c757d;
      color: white;
    }

    /* Responsive */
    @media (max-width: 768px) {
      .container {
        padding: 0 15px;
      }
      
      .btn {
        width: 100%;
        margin: 5px 0;
      }
    }
  </style>
</head>
<body>
  <?php if (session_status() === PHP_SESSION_NONE) session_start(); ?>

  <h2><i class="fas fa-money-bill-wave"></i> Modifier une dépense liée à un bien</h2>
  
  <div class="container">
    <div class="card">
      <form method="POST" action="/update_depense_bien/<?= $depense['id_depenses_biens'] ?>">
        <?php if (!isset($biens)): ?>
          <div class="alert">
            <i class="fas fa-exclamation-triangle"></i> La variable $biens n'est pas définie.
          </div>
        <?php endif; ?>
        
        <?php if (empty($biens)): ?>
          <div class="alert">
            <i class="fas fa-exclamation-triangle"></i> Aucun bien trouvé pour cet utilisateur.
          </div>
        <?php endif; ?>

        <div class="form-group">
          <label><i class="fas fa-home"></i> Bien associé :</label>
          <select name="id_bien" required>
            <option value="">-- Sélectionner un bien --</option>
            <?php 
                $uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
                $uri = str_replace('/www.patrimoine360.com/public/index.php/', '', $uri);
                $segments = explode('/', trim($uri, '/'));
                $route = $segments[0] ?? null;
                $id_bien = $segments[1] ?? null;
            ?>
            <?php foreach ($biens as $b): ?>
              <option value="<?= $b['id_bien'] ?>" <?= ($b['id_bien'] == $id_bien) ? 'selected' : '' ?>>
                <?= htmlspecialchars($b['libelle_bien']) ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-coins"></i> Montant de la dépense :</label>
          <input type="number" name="montant_depense" step="0.01" value="<?= $depense['montant_depense'] ?>" required>
        </div>

        <div class="form-group">
          <label><i class="fas fa-comment-alt"></i> Motif spécifique :</label>
          <textarea name="motif_depense_bien"><?= htmlspecialchars($depense['motif_depense_bien']) ?></textarea>
        </div>

        <div class="form-group">
          <label><i class="fas fa-sync-alt"></i> Fréquence :</label>
          <select name="frequence_depense">
            <?php
              $frequences = ['Mensuelle','Trimestrielle','Annuelle'];
              foreach ($frequences as $f) {
                $selected = ($depense['frequence_depense'] === $f) ? 'selected' : '';
                echo "<option $selected>$f</option>";
              }
            ?>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-comment"></i> Motif général :</label>
          <input type="text" name="motif_depense" value="<?= htmlspecialchars($depense['motif_depense']) ?>">
        </div>

        <div class="form-group">
          <label><i class="fas fa-file-alt"></i> Pièce justificative :</label>
          <input type="text" name="piece_justificative" value="<?= htmlspecialchars($depense['piece_justificative']) ?>">
        </div>

        <div class="form-group">
          <label><i class="fas fa-calendar"></i> Mois :</label>
          <select name="mois_depense">
            <?php
              $mois = ['Janvier','Février','Mars','Avril','Mai','Juin','Juillet','Août','Septembre','Octobre','Novembre','Décembre'];
              foreach ($mois as $m) {
                $selected = ($depense['mois_depense'] === $m) ? 'selected' : '';
                echo "<option $selected>$m</option>";
              }
            ?>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-calendar-alt"></i> Année :</label>
          <select name="annee_depense" required>
            <?php
              for ($year = 2025; $year <= 2055; $year++) {
                $selected = ($depense['annee_depense'] == $year) ? 'selected' : '';
                echo "<option value='$year' $selected>$year</option>";
              }
            ?>
          </select>
        </div>

        <div>
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Enregistrer les modifications
          </button>
          <a href="../depenses_biens" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Annuler
          </a>
        </div>
      </form>
    </div>
  </div>
</body>
</html>