<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Modifier un compte - Gespes360</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="icon" href="favicon.ico" type="../image/x-icon" />
  <!-- END META SECTION -->
  <!-- CSS INCLUDE -->        
  <link rel="stylesheet" type="text/css" id="theme" href="../../css/theme-default.css"/>
  <!-- EOF CSS INCLUDE --> 
  
  <style>
    /* Styles cohérents avec le dashboard */
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4f6f8;
      color: #333;
    }

    h2 {
      background-color: #6610f2;
      color: white;
      padding: 20px;
      margin: 0;
      text-align: center;
      font-size: 24px;
    }

    .container {
      max-width: 800px;
      margin: 30px auto;
      padding: 0 20px;
    }

    .card {
      background-color: white;
      border-radius: 10px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      padding: 25px;
      margin-bottom: 30px;
    }

    /* Formulaires */
    .form-group {
      margin-bottom: 20px;
    }

    label {
      display: block;
      margin-bottom: 8px;
      font-weight: 500;
    }

    input[type="text"],
    input[type="number"],
    input[type="datetime-local"],
    input[type="hidden"],
    select,
    textarea {
      width: 100%;
      padding: 10px 15px;
      border: 1px solid #ddd;
      border-radius: 5px;
      font-size: 15px;
      transition: border 0.3s;
      margin-bottom: 10px;
    }

    input:focus,
    select:focus {
      border-color: #6610f2;
      outline: none;
      box-shadow: 0 0 0 3px rgba(102,16,242,0.1);
    }

    /* Boutons */
    .btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: 10px 20px;
      border-radius: 5px;
      text-decoration: none;
      font-weight: 500;
      transition: all 0.2s;
      border: none;
      cursor: pointer;
      font-size: 15px;
      margin: 5px;
    }

    .btn i {
      margin-right: 8px;
    }

    .btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 8px rgba(0,0,0,0.15);
    }

    .btn-primary {
      background-color: #6610f2;
      color: white;
    }

    .btn-secondary {
      background-color: #6c757d;
      color: white;
    }

    .btn-danger {
      background-color: #dc3545;
      color: white;
    }

    /* Responsive */
    @media (max-width: 768px) {
      .container {
        padding: 0 15px;
      }
    }
  </style>
</head>
<body>
  <?php if (session_status() === PHP_SESSION_NONE) session_start(); ?>

  <h2><i class="fas fa-edit"></i> Modifier un compte</h2>
  
  <div class="container">
    <div class="card">
      <form method="POST" action="../update_compte/<?= $compte['id_compte'] ?>">
        <input type="hidden" name="id_utilisateur" value="<?= $_SESSION['user']['id_utilisateur'] ?>">
        <?php 
            $uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
            $uri = str_replace('som-cm.com/bewise/public/index.php', '', $uri);
            $segments = explode('/', trim($uri, '/'));
            $route = $segments[0] ?? null;
            $id_compte = $segments[1] ?? null;
        ?>    
        
        <div class="form-group">
          <label><i class="fas fa-signature"></i> Nom du compte :</label>
          <input type="hidden" name="id_compte" value="<?= $id_compte ?>" required>
          <input type="text" name="nom_compte" value="<?= htmlspecialchars($compte['nom_compte']) ?>" required>
        </div>

        <div class="form-group">
          <label><i class="fas fa-list"></i> Type de compte :</label>
          <select name="type_compte">
            <?php
              $types = ['courant','épargne','investissement','salaire','caisse','poche'];
              foreach ($types as $type) {
                $selected = ($compte['type_compte'] === $type) ? 'selected' : '';
                echo "<option value=\"$type\" $selected>$type</option>";
              }
            ?>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-money-bill-wave"></i> Devise :</label>
          <select name="devise">
            <?php
              $devises = ['FCFA','EUR','DOLLAR américain','DOLLAR canadien'];
              foreach ($devises as $devise) {
                $selected = ($compte['devise'] === $devise) ? 'selected' : '';
                echo "<option value=\"$devise\" $selected>$devise</option>";
              }
            ?>
          </select>
        </div>

        <div class="form-group">
          <label><i class="fas fa-coins"></i> Solde :</label>
          <input type="number" name="solde" step="0.01" value="<?= $compte['solde'] ?>">
        </div>

        <div class="form-group">
          <label><i class="fas fa-exclamation-triangle"></i> Limite découvert :</label>
          <input type="number" name="limite_decouvert" step="0.01" value="<?= $compte['limite_decouvert'] ?>">
        </div>

        <div class="form-group">
          <label><i class="fas fa-percentage"></i> Taux d'intérêt :</label>
          <input type="number" name="taux_interet" step="0.01" value="<?= $compte['taux_interet'] ?>">
        </div>

        <div class="form-group">
          <label><i class="fas fa-door-open"></i> Mode d'ouverture :</label>
          <input type="text" name="mode_ouverture" value="<?= htmlspecialchars($compte['mode_ouverture']) ?>">
        </div>

        <div class="form-group">
          <label><i class="fas fa-calendar-alt"></i> Date dernière activité :</label>
          <input type="datetime-local" name="date_derniere_activite" value="<?= date('Y-m-d\TH:i', strtotime($compte['date_derniere_activite'])) ?>">
        </div>

        <div class="form-group">
          <label><i class="fas fa-info-circle"></i> Statut :</label>
          <select name="statut">
            <option value="actif" <?= $compte['statut'] === 'actif' ? 'selected' : '' ?>>actif</option>
            <option value="inactif" <?= $compte['statut'] === 'inactif' ? 'selected' : '' ?>>inactif</option>
          </select>
        </div>

        <div>
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Enregistrer les modifications
          </button>
          <a href="../comptes" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Annuler
          </a>
        </div>
      </form>
    </div>
  </div>
</body>
</html>