<!DOCTYPE html>
<html lang="fr">
<head>

  <title>Tableau de bord - BeWise</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="icon" href="favicon.ico" type="../image/x-icon" />
  <!-- END META SECTION -->
  <!-- CSS INCLUDE -->        
  <link rel="stylesheet" type="text/css" id="theme" href="../css/theme-default.css"/>
  <!-- EOF CSS INCLUDE --> 
<style>

.dashboard-container {
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
  gap: 20px;
  padding: 40px 20px;
}

.dashboard-button {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  text-decoration: none;
  color: white;
  padding: 20px;
  border-radius: 10px;
  width: 200px;
  height: 120px;
  font-size: 15px;
  box-shadow: 0 4px 8px rgba(0,0,0,0.1);
  transition: transform 0.2s;
}

.dashboard-button:hover {
  transform: scale(1.05);
}

.dashboard-button i {
  font-size: 28px;
  margin-bottom: 10px;
}

/* Couleurs par module */
.profil { background-color: #6c757d; }
.depenses { background-color: #dc3545; }
.epargnes { background-color: #28a745; }
.dettes { background-color: #ffc107; color: #212529; }
.biens { background-color: #17a2b8; }
.depenses_biens { background-color: #fd7e14; }
.revenus_biens { background-color: #20c997; }
.comptes { background-color: #6610f2; }
.revenus { background-color: #007bff; }
.fin_dep { background-color: #343a40; }
.fin_ep { background-color: #198754; }
.logout { background-color: #d63384; }

  body {
    margin: 0;
    font-family: 'Segoe UI', sans-serif;
    background-color: #f4f6f8;
    color: #333;
  }

  h2 {
    background-color: #007bff;
    color: white;
    padding: 20px;
    margin: 0;
    text-align: center;
    font-size: 24px;
  }

  nav {
    background-color: #fff;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    padding: 20px;
    max-width: 300px;
    margin: 30px auto;
    border-radius: 10px;
  }

  nav ul {
    list-style: none;
    padding: 0;
    margin: 0;
  }

  nav li {
    margin: 10px 0;
  }

  nav a {
    text-decoration: none;
    color: #007bff;
    font-weight: bold;
    transition: color 0.3s;
  }

  nav a:hover {
    color: #0056b3;
  }

  footer {
    margin-top: 50px;
    text-align: center;
    color: #888;
    font-size: 14px;
  }
</style>

</head>
<body>
<?php
    @session_start();
    $id_user = $_SESSION['user']['id_utilisateur']; // ou le nom de ta variable session
    require_once '../app/models/ConseilsModel.php';
    $model = new ConseilsModel();
    $conseils = $model->getConseilsByUtilisateur($id_user);
?>

  <h2>Bienvenue, <?= $_SESSION['user']['prenom'] ?> !</h2>

  <div class="dashboard-container">
    <a href="../index.php/profil" class="dashboard-button profil"><i class="fas fa-user"></i>Profil</a>
    <a href="../index.php/comptes" class="dashboard-button comptes"><i class="fas fa-wallet"></i>Comptes</a>
    <a href="../index.php/depenses" class="dashboard-button depenses"><i class="fas fa-money-bill-wave"></i>Dépenses</a>
    <a href="../index.php/epargne_ct" class="dashboard-button epargnes"><i class="fas fa-piggy-bank"></i>Épargnes</a>
    <a href="../index.php/dettes" class="dashboard-button dettes"><i class="fas fa-file-invoice-dollar"></i>Dettes</a>
    <a href="../index.php/biens" class="dashboard-button biens"><i class="fas fa-home"></i>Biens</a>
    <a href="../index.php/statistiques" class="dashboard-button logout"><i class="fas fa-sign-out-alt"></i>Statistiques</a>
    <a href="../index.php/conseils" class="dashboard-button profil"><i class="fas fa-user"></i>Education</a>
    <a href="../index.php/depenses_biens" class="dashboard-button depenses_biens"><i class="fas fa-chart-line"></i>Dépenses Biens</a>
    <a href="../index.php/revenus_biens" class="dashboard-button revenus_biens"><i class="fas fa-coins"></i>Revenus Biens</a>
    <a href="../index.php/revenus" class="dashboard-button revenus"><i class="fas fa-hand-holding-usd"></i>Revenus</a>
    <a href="../index.php/financements_depenses" class="dashboard-button fin_dep"><i class="fas fa-arrow-circle-up"></i>Financer Dépenses</a>
    <a href="../index.php/financements_epargnes" class="dashboard-button fin_ep"><i class="fas fa-arrow-circle-down"></i>Financer Épargnes</a>
    <a href="../index.php/logout" class="dashboard-button logout"><i class="fas fa-sign-out-alt"></i>Déconnexion</a>
  </div>


<footer>
  Discipline et liberté financière : la voix vers la richesse.
</footer>


<script>
  const conseils = <?= json_encode($conseils) ?>;
</script>


<script>
function afficherConseilAleatoire() {
  if (!conseils || conseils.length === 0) return;

  const index = Math.floor(Math.random() * conseils.length);
  const conseil = conseils[index];

  const popup = document.createElement("div");
  popup.innerHTML = `
    <div style="display:flex; justify-content:space-between; align-items:center;">
      <strong style="font-size:18px;">${conseil.type_conseil.toUpperCase()}</strong>
      <span style="cursor:pointer; font-size:20px;" onclick="this.parentElement.parentElement.remove()">✖️</span>
    </div>
    <div style="margin-top:15px; font-size:16px;">${conseil.message_conseil}</div>
  `;

  popup.style.position = "fixed";
  popup.style.top = "50%";
  popup.style.left = "50%";
  popup.style.transform = "translate(-50%, -50%)";
  popup.style.background = "#007bff";
  popup.style.color = "#fff";
  popup.style.padding = "30px";
  popup.style.borderRadius = "15px";
  popup.style.boxShadow = "0 0 30px rgba(0,0,0,0.4)";
  popup.style.zIndex = "9999";
  popup.style.maxWidth = "500px";
  popup.style.textAlign = "center";
  popup.style.fontFamily = "Segoe UI, sans-serif";
  popup.style.opacity = "0";
  popup.style.transition = "opacity 0.5s ease";

  document.body.appendChild(popup);

  setTimeout(() => popup.style.opacity = "1", 50); // animation d’apparition
  setTimeout(() => popup.remove(), 30000); // disparaît après 30 secondes
}

setInterval(afficherConseilAleatoire, 60000); // toutes les 60 secondes
</script>






</body>
</html>
