<?php
if (session_status() === PHP_SESSION_NONE) @session_start();
?>

<!DOCTYPE html>
<html lang="fr">
<head>

    <title>Gestion des Conseils - BeWise</title>
    
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="icon" href="favicon.ico" type="../image/x-icon" />
  <!-- END META SECTION -->
  <!-- CSS INCLUDE -->        
  <link rel="stylesheet" type="text/css" id="theme" href="../css/theme-default.css"/>
  <!-- EOF CSS INCLUDE -->   
    <style>
        :root {
            --primary-color: #20c997;
            --secondary-color: #6c757d;
            --success-color: #28a745;
            --info-color: #17a2b8;
            --warning-color: #ffc107;
            --danger-color: #dc3545;
            --light-color: #f8f9fa;
            --dark-color: #343a40;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f6f8;
            color: #333;
            line-height: 1.6;
        }
        
        .header {
            background-color: #6c757d;
            color: white;
            padding: 20px;
            text-align: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        
        .container {
            max-width: 1200px;
            margin: 30px auto;
            padding: 0 20px;
        }
        
        .card {
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            padding: 25px;
            margin-bottom: 30px;
        }
        
        .filters {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
            margin-bottom: 20px;
            background: white;
            padding: 15px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .filter-group {
            flex: 1;
            min-width: 200px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: #495057;
        }
        
        select, input[type="text"], input[type="date"] {
            width: 100%;
            padding: 10px 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 15px;
            transition: border 0.3s;
        }
        
        select:focus, input:focus {
            border-color: var(--primary-color);
            outline: none;
            box-shadow: 0 0 0 3px rgba(32,201,151,0.1);
        }
        
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 10px 20px;
            border-radius: 5px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.2s;
            border: none;
            cursor: pointer;
            font-size: 15px;
            margin: 5px;
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            color: white;
        }
        
        .btn-secondary {
            background-color: var(--secondary-color);
            color: white;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
        }
        
        .conseils-container {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
            gap: 20px;
            margin-top: 20px;
        }
        
        .conseil-card {
            background: white;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            transition: transform 0.3s, box-shadow 0.3s;
            border-left: 4px solid;
        }
        
        .conseil-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        
        .conseil-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }
        
        .conseil-type {
            padding: 5px 10px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
            text-transform: uppercase;
            color: black;
        }
        
        .conseil-date {
            font-size: 12px;
            color: #6c757d;
        }
        
        .conseil-content {
            margin: 15px 0;
            color: #495057;
        }
        
        /* Couleurs par type de conseil */
        .type-strategique {
            border-color: var(--success-color);
            background-color: rgba(40,167,69,0.05);
        }
        
        .type-strategique .conseil-type {
            background-color: var(--primary-color);
        }
        
        .type-coaching {
            border-color: var(--info-color);
            background-color: rgba(23,162,184,0.05);
        }
        
        .type-coaching .conseil-type {
            background-color: var(--info-color);
        }
        
        .type-comportemental {
            border-color: var(--warning-color);
            background-color: rgba(255,193,7,0.05);
        }
        
        .type-comportemental .conseil-type {
            background-color: var(--warning-color);
            color: #212529;
        }
        
        .type-pedagogique {
            border-color: var(--success-color);
            background-color: rgba(40,167,69,0.05);
        }
        
        .type-pedagogique .conseil-type {
            background-color: var(--success-color);
        }
        
        .type-regle {
            border-color: var(--danger-color);
            background-color: rgba(220,53,69,0.05);
        }
        
        .type-regle .conseil-type {
            background-color: var(--danger-color);
        }
        
        .type-init {
            border-color: var(--secondary-color);
            background-color: rgba(108,117,125,0.05);
        }
        
        .type-init .conseil-type {
            background-color: var(--secondary-color);
        }
        
        .no-results {
            text-align: center;
            padding: 40px;
            color: #6c757d;
            font-size: 18px;
            grid-column: 1 / -1;
        }
        
        @media (max-width: 768px) {
            .container {
                padding: 0 15px;
            }
            
            .conseils-container {
                grid-template-columns: 1fr;
            }
            
            .filters {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <h1><i class="fas fa-lightbulb"></i> Vos Conseils Personnalisés</h1>
    </div>
    
    <div class="container">
        <div class="card">
            <h2>Filtres des Conseils</h2>
            
            <div class="filters">
                <div class="filter-group">
                    <label for="type-filter">Type de conseil</label>
                    <select id="type-filter">
                        <option value="">Tous les types</option>
                        <option value="stratégique">Stratégique</option>
                        <option value="coaching">Coaching</option>
                        <option value="comportemental">Comportemental</option>
                        <option value="pedagogique">Pédagogique</option>
                        <option value="regle">Règles</option>
                        <option value="init">Initialisation</option>
                    </select>
                </div>
                
                <div class="filter-group">
                    <label for="date-filter">Période</label>
                    <select id="date-filter">
                        <option value="">Toutes les dates</option>
                        <option value="today">Aujourd'hui</option>
                        <option value="week">Cette semaine</option>
                        <option value="month">Ce mois</option>
                        <option value="year">Cette année</option>
                    </select>
                </div>
                
                <div class="filter-group">
                    <label for="search-filter">Recherche texte</label>
                    <input type="text" id="search-filter" placeholder="Rechercher dans les conseils...">
                </div>
            </div>
            
            <div>
                <button id="reset-filters" class="btn btn-secondary">Réinitialiser les filtres</button>
                <button id="apply-filters" class="btn btn-primary">Appliquer les filtres</button>
                <a href="../index.php/dashboard" id="dashboard" class="btn btn-secondary">Retour au dashboard</a>
            </div>
        </div>
        
        <div class="card">
            <h2>Vos Conseils</h2>
            <p>Retrouvez ici tous les conseils personnalisés générés pour vous aider dans votre gestion patrimoniale.</p>
            
            <div class="conseils-container" id="conseils-list">
                <?php foreach ($conseils as $conseil): ?>
                    <div class="conseil-card type-<?= htmlspecialchars(strtolower(explode(' ', $conseil['type_conseil'])[0])) ?>">
                        <div class="conseil-header">
                            <span class="conseil-type"><?= htmlspecialchars($conseil['type_conseil']) ?></span>
                            <span class="conseil-date"><?= date('d/m/Y H:i', strtotime($conseil['date_generation'])) ?></span>
                        </div>
                        <div class="conseil-content">
                            <?= nl2br(htmlspecialchars($conseil['message_conseil'])) ?>
                        </div>
                    </div>
                <?php endforeach; ?>
                
                <?php if (empty($conseils)): ?>
                    <div class="no-results">
                        <p>Aucun conseil disponible pour le moment.</p>
                        <p>Votre tableau de bord sera mis à jour avec des conseils personnalisés en fonction de votre activité.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const conseils = document.querySelectorAll('.conseil-card');
            const typeFilter = document.getElementById('type-filter');
            const dateFilter = document.getElementById('date-filter');
            const searchFilter = document.getElementById('search-filter');
            const applyBtn = document.getElementById('apply-filters');
            const resetBtn = document.getElementById('reset-filters');
            
            function applyFilters() {
                const typeValue = typeFilter.value;
                const dateValue = dateFilter.value;
                const searchValue = searchFilter.value.toLowerCase();
                const today = new Date();
                
                let visibleCount = 0;
                
                conseils.forEach(conseil => {
                    const type = conseil.classList.contains('type-' + typeValue) || !typeValue;
                    const textMatch = conseil.textContent.toLowerCase().includes(searchValue) || !searchValue;
                    
                    let dateMatch = true;
                    if (dateValue) {
                        const dateText = conseil.querySelector('.conseil-date').textContent;
                        const conseilDate = new Date(
                            dateText.split('/')[2].split(' ')[0], // année
                            dateText.split('/')[1] - 1, // mois (0-indexé)
                            dateText.split('/')[0]  // jour
                        );
                        
                        switch(dateValue) {
                            case 'today':
                                dateMatch = conseilDate.toDateString() === today.toDateString();
                                break;
                            case 'week':
                                const weekStart = new Date(today);
                                weekStart.setDate(today.getDate() - today.getDay());
                                dateMatch = conseilDate >= weekStart;
                                break;
                            case 'month':
                                dateMatch = conseilDate.getMonth() === today.getMonth() && 
                                             conseilDate.getFullYear() === today.getFullYear();
                                break;
                            case 'year':
                                dateMatch = conseilDate.getFullYear() === today.getFullYear();
                                break;
                        }
                    }
                    
                    if (type && textMatch && dateMatch) {
                        conseil.style.display = 'block';
                        visibleCount++;
                    } else {
                        conseil.style.display = 'none';
                    }
                });
                
                // Afficher un message si aucun résultat
                const noResults = document.querySelector('.no-results');
                if (visibleCount === 0 && conseils.length > 0) {
                    if (!noResults) {
                        const conseilsList = document.getElementById('conseils-list');
                        const message = document.createElement('div');
                        message.className = 'no-results';
                        message.innerHTML = '<p>Aucun conseil ne correspond à vos critères de recherche.</p>';
                        conseilsList.appendChild(message);
                    }
                } else if (noResults && visibleCount > 0) {
                    noResults.remove();
                }
            }
            
            applyBtn.addEventListener('click', applyFilters);
            
            resetBtn.addEventListener('click', function() {
                typeFilter.value = '';
                dateFilter.value = '';
                searchFilter.value = '';
                applyFilters();
            });
            
            // Appliquer les filtres lors de la frappe dans la recherche
            searchFilter.addEventListener('input', function() {
                clearTimeout(this.timer);
                this.timer = setTimeout(applyFilters, 500);
            });
            
            // Appliquer les filtres au chargement si des paramètres sont présents
            const urlParams = new URLSearchParams(window.location.search);
            if (urlParams.has('type')) typeFilter.value = urlParams.get('type');
            if (urlParams.has('date')) dateFilter.value = urlParams.get('date');
            if (urlParams.has('search')) searchFilter.value = urlParams.get('search');
            
            if (typeFilter.value || dateFilter.value || searchFilter.value) {
                applyFilters();
            }
        });
    </script>
</body>
</html>