<?php
// Début de session et traitement flash message
if (session_status() === PHP_SESSION_NONE) @session_start();

$notification = '';
if (!empty($_SESSION['flash'])) {
    $flash = $_SESSION['flash'];
    unset($_SESSION['flash']);
    
    $icons = [
        'success' => 'fa-check-circle',
        'danger' => 'fa-exclamation-circle',
        'warning' => 'fa-exclamation-triangle',
        'info' => 'fa-info-circle'
    ];
    
    $icon = $icons[$flash['type']] ?? 'fa-info-circle';
    
    $notification = <<<HTML
    <div class="notification notification-{$flash['type']}">
        <div class="notification-icon">
            <i class="fas {$icon}"></i>
        </div>
        <div class="notification-content">
            {$flash['message']}
        </div>
        <div class="notification-close">
            <i class="fas fa-times"></i>
        </div>
    </div>
HTML;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Gestion des comptes - BeWise</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="icon" href="favicon.ico" type="../image/x-icon" />
  <link rel="stylesheet" type="text/css" id="theme" href="../css/theme-default.css"/>
  
  <style>
    /* Styles de base */
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4f6f8;
      color: #333;
      line-height: 1.6;
    }

    h2 {
      background-color: #6610f2;
      color: white;
      padding: 20px;
      margin: 0;
      text-align: center;
      font-size: 24px;
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }

    .container {
      max-width: 1200px;
      margin: 30px auto;
      padding: 0 20px;
    }

    .card {
      background-color: white;
      border-radius: 10px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      padding: 25px;
      margin-bottom: 30px;
      max-width: 100%;
    }

    /* Formulaires */
    .form-group {
      margin-bottom: 20px;
    }

    label {
      display: block;
      margin-bottom: 8px;
      font-weight: 500;
      color: #555;
    }

    input[type="text"],
    input[type="number"],
    input[type="datetime-local"],
    select,
    textarea {
      width: 100%;
      padding: 12px 15px;
      border: 1px solid #ddd;
      border-radius: 6px;
      font-size: 15px;
      transition: all 0.3s;
    }

    input:focus,
    select:focus {
      border-color: #6610f2;
      outline: none;
      box-shadow: 0 0 0 3px rgba(102,16,242,0.1);
    }

    /* Boutons */
    .btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: 12px 20px;
      border-radius: 6px;
      text-decoration: none;
      font-weight: 500;
      transition: all 0.2s;
      border: none;
      cursor: pointer;
      font-size: 15px;
      margin: 5px;
    }

    .btn i {
      margin-right: 8px;
    }

    .btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 8px rgba(0,0,0,0.15);
    }

    .btn-primary {
      background-color: #6610f2;
      color: white;
    }

    .btn-secondary {
      background-color: #6c757d;
      color: white;
    }

    .btn-danger {
      background-color: #dc3545;
      color: white;
    }

    .btn-sm {
      padding: 8px 12px;
      font-size: 14px;
    }

    /* Tableau et responsive */
    .table-responsive {
      overflow-x: auto;
      margin-top: 20px;
      border-radius: 10px;
    }
    
    table {
      width: 100%;
      min-width: 600px;
      max-width: 100%;
      border-collapse: separate;
      border-spacing: 0;
      margin: 20px 0;
      background: white;
      border-radius: 10px;
      overflow: hidden;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }

    th, td {
      padding: 14px 16px;
      text-align: left;
      border-bottom: 1px solid #eee;
    }

    th {
      background-color: #6610f2;
      color: white;
      font-weight: 500;
      position: sticky;
      top: 0;
    }

    /* Styles des lignes du tableau */
    tr {
      transition: background-color 0.2s;
    }

    tr:nth-child(even) {
      background-color: #f9f9f9;
    }

    tr:hover {
      background-color: #f1f1f1;
    }

    /* Filtres */
    .filters {
      display: flex;
      flex-wrap: wrap;
      gap: 15px;
      margin-bottom: 20px;
      background: white;
      padding: 20px;
      border-radius: 10px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }

    .filter-group {
      flex: 1;
      min-width: 200px;
    }

    /* Actions */
    .actions {
      display: flex;
      gap: 8px;
    }

    .actions form {
      margin: 0;
    }

    /* Notifications */
    .notification {
      position: relative;
      display: flex;
      align-items: center;
      padding: 16px 20px;
      margin: 20px auto;
      max-width: 800px;
      border-radius: 8px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
      animation: slideIn 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94) forwards;
      overflow: hidden;
      z-index: 1000;
    }
    
    .notification::after {
      content: '';
      position: absolute;
      left: 0;
      top: 0;
      height: 100%;
      width: 5px;
    }
    
    .notification-success {
      background-color: #f0fdf4;
      color: #166534;
    }
    .notification-success::after {
      background-color: #22c55e;
    }
    
    .notification-danger {
      background-color: #fef2f2;
      color: #991b1b;
    }
    .notification-danger::after {
      background-color: #ef4444;
    }
    
    .notification-warning {
      background-color: #fefce8;
      color: #854d0e;
    }
    .notification-warning::after {
      background-color: #f59e0b;
    }
    
    .notification-info {
      background-color: #eff6ff;
      color: #1e40af;
    }
    .notification-info::after {
      background-color: #3b82f6;
    }
    
    .notification-icon {
      font-size: 1.5rem;
      margin-right: 16px;
      min-width: 24px;
    }
    
    .notification-content {
      flex: 1;
      padding-right: 10px;
    }
    
    .notification-close {
      margin-left: 10px;
      cursor: pointer;
      opacity: 0.7;
      transition: opacity 0.2s;
      padding: 5px;
    }
    
    .notification-close:hover {
      opacity: 1;
    }

    /* Styles pour les types de comptes */
    .type-courant { background-color: #e0f2fe; }
    .type-épargne { background-color: #ecfdf5; }
    .type-investissement { background-color: #f5f3ff; }
    .type-salaire { background-color: #ffedd5; }
    .type-caisse { background-color: #fce7f3; }
    .type-poche { background-color: #f0fdfa; }

    /* Styles pour les statuts */
    .statut-actif { color: #166534; font-weight: 500; }
    .statut-inactif { color: #991b1b; font-weight: 500; }

    /* Style pour les soldes */
    .solde-positif { color: #166534; font-weight: 600; }
    .solde-negatif { color: #991b1b; font-weight: 600; }

    /* Animations */
    @keyframes slideIn {
      from { transform: translateY(-30px); opacity: 0; }
      to { transform: translateY(0); opacity: 1; }
    }

    @keyframes slideOut {
      from { transform: translateY(0); opacity: 1; }
      to { transform: translateY(-30px); opacity: 0; }
    }

    /* Responsive */
    @media (max-width: 768px) {
      .container {
        padding: 0 15px;
      }
      
      th, td {
        padding: 10px 12px;
        font-size: 14px;
      }
      
      .filters {
        flex-direction: column;
        gap: 12px;
        padding: 15px;
      }
      
      .actions {
        flex-direction: column;
        gap: 6px;
      }
      
      .notification {
        margin: 15px;
        padding: 14px;
      }
      
      .notification-icon {
        font-size: 1.3rem;
        margin-right: 12px;
      }
    }

 /* Nouveaux styles pour les types de comptes */
    .type-courant { 
      background-color: #fee2e2; /* Rouge clair */
      border-left: 4px solid #ef4444; /* Bordure rouge */
    }
    .type-épargne { 
      background-color: #dcfce7; /* Vert clair */
      border-left: 4px solid #22c55e; /* Bordure verte */
    }
    .type-investissement { 
      background-color: #e0e7ff; /* Bleu clair */
      border-left: 4px solid #3b82f6; /* Bordure bleue */
    }
    .type-salaire { 
      background-color: #fef3c7; /* Jaune clair */
      border-left: 4px solid #f59e0b; /* Bordure orange */
    }
    .type-caisse { 
      background-color: #f3e8ff; /* Violet clair */
      border-left: 4px solid #a855f7; /* Bordure violette */
    }
    .type-poche { 
      background-color: #ecfdf5; /* Cyan clair */
      border-left: 4px solid #14b8a6; /* Bordure turquoise */
    }

    /* Amélioration du survol des lignes */
    tr.type-courant:hover { background-color: #fecaca !important; }
    tr.type-épargne:hover { background-color: #bbf7d0 !important; }
    tr.type-investissement:hover { background-color: #c7d2fe !important; }
    tr.type-salaire:hover { background-color: #fde68a !important; }
    tr.type-caisse:hover { background-color: #e9d5ff !important; }
    tr.type-poche:hover { background-color: #a7f3d0 !important; }

    /* Style des cellules de type */
    td[data-type] {
      font-weight: 600;
      text-transform: capitalize;
    }
    td[data-type="courant"] { color: #b91c1c; }
    td[data-type="épargne"] { color: #15803d; }
    td[data-type="investissement"] { color: #1d4ed8; }
    td[data-type="salaire"] { color: #b45309; }
    td[data-type="caisse"] { color: #7e22ce; }
    td[data-type="poche"] { color: #0f766e; }
    
  </style>
</head>
<body>
  <h2><i class="fas fa-wallet"></i> Gestion des comptes</h2>
  
  <?= $notification ?>
  
  <div class="container">
    <!-- Section d'ajout -->
    <div class="card">
      <h3 style="margin-top: 0; color: #6610f2;"><i class="fas fa-plus-circle"></i> Ajouter un compte</h3>
      <form method="POST" action="../index.php/store_compte">
        <input type="hidden" name="id_utilisateur" value="<?= $id_utilisateur ?>">
    
        <div class="form-group">
            <label><i class="fas fa-signature"></i> Nom du compte :</label>
            <input type="text" name="nom_compte" required 
                   placeholder="Ex: Compte courant BICEC" 
                   title="Entrez le nom de votre compte">
        </div>
    
        <div class="form-group">
            <label><i class="fas fa-list"></i> Type de compte :</label>
            <select name="type_compte" required>
                <option value="" disabled selected>Sélectionnez un type</option>
                <option value="courant" selected>courant</option>
                <option value="épargne">épargne</option>
                <option value="investissement">investissement</option>
                <option value="salaire">salaire</option>
                <option value="caisse">caisse</option>
                <option value="poche">poche</option>
            </select>
        </div>
    
        <div class="form-group">
            <label><i class="fas fa-money-bill-wave"></i> Devise :</label>
            <select name="devise" required>
                <option value="FCFA" selected>FCFA</option>
                <option value="EUR">EUR</option>
                <option value="DOLLAR américain">DOLLAR américain</option>
                <option value="DOLLAR canadien">DOLLAR canadien</option>
            </select>
        </div>
    
        <div class="form-group">
            <label><i class="fas fa-coins"></i> Solde :</label>
            <input type="number" name="solde" step="0.01" required
                   placeholder="0.00" 
                   min="0" 
                   title="Entrez le solde initial">
        </div>
    
        <div class="form-group">
            <label><i class="fas fa-exclamation-triangle"></i> Limite découvert :</label>
            <input type="number" name="limite_decouvert" step="0.01"
                   placeholder="0.00" 
                   min="0" 
                   value="0"
                   title="Entrez la limite de découvert autorisée">
        </div>
    
        <div class="form-group">
            <label><i class="fas fa-percentage"></i> Taux d'intérêt :</label>
            <input type="number" name="taux_interet" step="0.01"
                   placeholder="0.00" 
                   min="0" max="100" 
                   value="0"
                   title="Entrez le taux d'intérêt en %">
        </div>
    
        <div class="form-group">
            <label><i class="fas fa-door-open"></i> Mode d'ouverture :</label>
            <input type="text" name="mode_ouverture"
                   placeholder="Ex: En agence, En ligne..." 
                   value="en ligne"
                   title="Comment le compte a été ouvert">
        </div>
    
        <div class="form-group">
            <label><i class="fas fa-calendar-alt"></i> Date dernière activité :</label>
            <input type="datetime-local" name="date_derniere_activite"
                   value="<?= date('Y-m-d\TH:i') ?>"
                   title="Date de la dernière activité sur le compte">
        </div>
    
        <div class="form-group">
            <label><i class="fas fa-info-circle"></i> Statut :</label>
            <select name="statut">
                <option value="actif" selected>actif</option>
                <option value="inactif">inactif</option>
            </select>
        </div>
    
        <div>
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Enregistrer
            </button>
            <a href="../index.php/dashboard" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Tableau de bord
            </a>
        </div>
      </form>
    </div>

    <!-- Section liste -->
    <div class="card">
      <h3 style="margin-top: 0; color: #6610f2;"><i class="fas fa-list"></i> Liste des comptes</h3>

      <div class="filters">
        <div class="filter-group">
          <label for="searchInput"><i class="fas fa-search"></i> Rechercher :</label>
          <input type="text" id="searchInput" placeholder="Nom, type, devise...">
        </div>

        <div class="filter-group">
          <label for="rowsPerPage"><i class="fas fa-table"></i> Lignes par page :</label>
          <select id="rowsPerPage">
            <option value="5">5</option>
            <option value="10" selected>10</option>
            <option value="20">20</option>
            <option value="50">50</option>
            <option value="100">100</option>
          </select>
        </div>
      </div>

      <div class="table-responsive">
        <table>
          <thead>
            <tr>
              <th><i class="fas fa-signature"></i> Nom</th>
              <th><i class="fas fa-list"></i> Type</th>
              <th><i class="fas fa-money-bill-wave"></i> Devise</th>
              <th><i class="fas fa-coins"></i> Solde</th>
              <th><i class="fas fa-info-circle"></i> Statut</th>
              <th><i class="fas fa-cog"></i> Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($comptes as $c): ?>
              <tr class="type-<?= $c['type_compte'] ?>">
                <td><?= htmlspecialchars($c['nom_compte']) ?></td>
                <td data-type="<?= $c['type_compte'] ?>">
                  <i class="fas fa-<?= 
                    $c['type_compte'] === 'courant' ? 'money-bill-wave' : 
                    ($c['type_compte'] === 'épargne' ? 'piggy-bank' : 
                    ($c['type_compte'] === 'investissement' ? 'chart-line' : 
                    ($c['type_compte'] === 'salaire' ? 'hand-holding-usd' : 
                    ($c['type_compte'] === 'caisse' ? 'cash-register' : 'wallet'))))
                  ?>"></i>
                  <?= $c['type_compte'] ?>
                </td>
                <td><?= $c['devise'] ?></td>
                <td class="<?= $c['solde'] >= 0 ? 'solde-positif' : 'solde-negatif' ?>">
                    <?= number_format($c['solde'], 0, ',', ' ') ?> <?= $c['devise'] ?>
                </td>
                <td class="statut-<?= $c['statut'] ?>">
                  <i class="fas fa-<?= $c['statut'] === 'actif' ? 'check-circle' : 'times-circle' ?>"></i>
                  <?= $c['statut'] ?>
                </td>
                <td class="actions">
                  <form method="GET" action="../index.php/edit_compte/<?= $c['id_compte'] ?>">
                    <button type="submit" class="btn btn-primary btn-sm">
                      <i class="fas fa-edit"></i>
                    </button>
                  </form>
                  <form method="POST" action="../index.php/delete_compte/<?= $c['id_compte'] ?>" onsubmit="return confirm('Supprimer ce compte ?');">
                    <button type="submit" class="btn btn-danger btn-sm">
                      <i class="fas fa-trash-alt"></i>
                    </button>
                  </form>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

  <script>
    // Gestion de la recherche et pagination
    const searchInput = document.getElementById('searchInput');
    const rowsPerPageSelect = document.getElementById('rowsPerPage');
    const tableBody = document.querySelector('table tbody');
    const allRows = Array.from(tableBody.querySelectorAll('tr'));

    function filterAndPaginate() {
      const keyword = searchInput.value.toLowerCase();
      const limit = parseInt(rowsPerPageSelect.value);
      let count = 0;

      allRows.forEach(row => {
        const text = row.textContent.toLowerCase();
        const match = text.includes(keyword);

        if (match) {
          if (count < limit) {
            row.style.display = '';
            count++;
          } else {
            row.style.display = 'none';
          }
        } else {
          row.style.display = 'none';
        }
      });
    }

    searchInput.addEventListener('input', filterAndPaginate);
    rowsPerPageSelect.addEventListener('change', filterAndPaginate);
    window.addEventListener('load', filterAndPaginate);
    
    // Gestion des notifications
    document.querySelectorAll('.notification-close').forEach(closeBtn => {
      closeBtn.addEventListener('click', (e) => {
        const notification = e.target.closest('.notification');
        notification.style.animation = 'slideOut 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94) forwards';
        setTimeout(() => {
          notification.remove();
        }, 400);
      });
    });

    // Fermeture automatique des notifications après 5 secondes
    const notifications = document.querySelectorAll('.notification');
    notifications.forEach(notification => {
      setTimeout(() => {
        notification.style.animation = 'slideOut 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94) forwards';
        setTimeout(() => {
          notification.remove();
        }, 400);
      }, 5000);
    });
  </script>
</body>
</html>