<?php
require_once '/home/dykqnvjf/public_html/bewise/app/kernel/Database_connexion.php';

class UtilisateursModel {

  private $db;

  public function __construct() {
    try {
      $this->db = new PDO('mysql:host=localhost;dbname=dykqnvjf_gespes360', 'dykqnvjf_gespes360', 'dykqnvjf_gespes360');
      $this->db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
      $this->db->exec("SET NAMES 'utf8'");
    } catch (PDOException $e) {
      die("Erreur de connexion à la base de données : " . $e->getMessage());
    }
  }


  public function insert($data) {
    $stmt = $this->db->prepare("
      INSERT INTO utilisateurs (
        nom, prenom, email, mot_de_passe, genre, date_naissance,
        niveau_education, profession, type_utilisateur,
        motivation_financiere, profil_risque, score_fidelite, statut
      ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'actif')
    ");
    $stmt->execute([
      $data['nom'],
      $data['prenom'],
      $data['email'],
      $data['password'],
      $data['genre'],
      $data['date_naissance'],
      $data['niveau_education'],
      $data['profession'],
      $data['type_utilisateur'],
      $data['motivation_financiere'],
      $data['profil_risque'],
      10
    ]);
  }

  public function verifyCredentials($email, $mot_de_passe) {
    $stmt = $this->db->prepare("SELECT * FROM utilisateurs WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($mot_de_passe, $user['mot_de_passe'])) {
      return $user;
    }
    return false;
  }

public function emailExists($email) {
    $query = "SELECT COUNT(*) FROM utilisateurs WHERE email = :email";
    $stmt = $this->db->prepare($query);
    $stmt->bindParam(':email', $email);
    $stmt->execute();
    
    return $stmt->fetchColumn() > 0;
}

  public function updateConnexionStats($id_utilisateur) {
    $stmt = $this->db->prepare("
      UPDATE utilisateurs SET
        derniere_connexion = NOW(),
        nombre_sessions = IFNULL(nombre_sessions, 0) + 1
      WHERE id_utilisateur = ?
    ");
    $stmt->execute([$id_utilisateur]);
  }

  public function listerUtilisateurs() {
    $stmt = $this->db->query("SELECT * FROM utilisateurs ORDER BY id_utilisateur DESC");
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
  }

  public function activer($id) {
    $stmt = $this->db->prepare("UPDATE utilisateurs SET statut = 'actif' WHERE id_utilisateur = ?");
    $stmt->execute([$id]);
  }

  public function desactiver($id) {
    $stmt = $this->db->prepare("UPDATE utilisateurs SET statut = 'inactif' WHERE id_utilisateur = ?");
    $stmt->execute([$id]);
  }

  public function supprimer($id) {
    $stmt = $this->db->prepare("DELETE FROM utilisateurs WHERE id_utilisateur = ?");
    $stmt->execute([$id]);
  }

public function updateProfil($data) {
  $sql = "UPDATE utilisateurs SET nom = ?, prenom = ?, email = ?, genre = ?, date_naissance = ?, niveau_education = ?, profession = ?, type_utilisateur = ?, motivation_financiere = ?, profil_risque = ? WHERE id_utilisateur = ?";
  $stmt = $this->db->prepare($sql);
  $stmt->execute([
    $data['nom'], $data['prenom'], $data['email'], $data['genre'], $data['date_naissance'],
    $data['niveau_education'], $data['profession'], $data['type_utilisateur'],
    $data['motivation_financiere'], $data['profil_risque'], $data['id_utilisateur']
  ]);
}

  public function getAllU() {
    $stmt = $this->db->query("SELECT id_utilisateur, nom, prenom FROM utilisateurs ORDER BY nom");
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
  }

  
  public function modifier($id, $data) {
    $stmt = $this->db->prepare("
      UPDATE utilisateurs SET
        nom = ?, prenom = ?, email = ?, genre = ?, date_naissance = ?,
        niveau_education = ?, profession = ?, type_utilisateur = ?,
        motivation_financiere = ?, profil_risque = ?
      WHERE id_utilisateur = ?
    ");
    $stmt->execute([
      $data['nom'],
      $data['prenom'],
      $data['email'],
      $data['genre'],
      $data['date_naissance'],
      $data['niveau_education'],
      $data['profession'],
      $data['type_utilisateur'],
      $data['motivation_financiere'],
      $data['profil_risque'],
      $id
    ]);
  }
}
?>