<?php

class Revenus_BiensModel {
  private $db;

  public function __construct() {
    $this->db = new PDO('mysql:host=localhost;dbname=dykqnvjf_gespes360', 'dykqnvjf_gespes360', 'dykqnvjf_gespes360');
  }

  public function getAll() {
    $stmt = $this->db->query("SELECT * FROM revenus_biens");
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
  }

  public function getByBien($id_bien) {
    $stmt = $this->db->prepare("SELECT * FROM revenus_biens WHERE id_bien = ?");
    $stmt->execute([$id_bien]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
  }

  public function getByUser($id_utilisateur) {
    $stmt = $this->db->prepare("SELECT id_bien, libelle_bien FROM biens WHERE id_utilisateur = ?");
    $stmt->execute([$id_utilisateur]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
  }

  public function find($id) {
    $stmt = $this->db->prepare("SELECT * FROM revenus_biens WHERE id_revenus_biens = ?");
    $stmt->execute([$id]);
    return $stmt->fetch(PDO::FETCH_ASSOC);
  }

  public function store($data) {
    $stmt = $this->db->prepare("INSERT INTO revenus_biens (id_bien, libelle_revenu_bien, montant_revenu, type_revenu_bien, origine_revenu, frequence, responsable_collecte, justificatif, mois_revenu, annee_revenu) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([
      $data['id_bien'],
      $data['libelle_revenu_bien'],
      $data['montant_revenu'],
      $data['type_revenu_bien'],
      $data['origine_revenu'],
      $data['frequence'],
      $data['responsable_collecte'],
      $data['justificatif'],
      $data['mois_revenu'],
      $data['annee_revenu']
    ]);
  }

  public function update($id, $data) {
    $stmt = $this->db->prepare("UPDATE revenus_biens SET id_bien = ?, libelle_revenu_bien = ?, montant_revenu = ?, type_revenu_bien = ?, origine_revenu = ?, frequence = ?, responsable_collecte = ?, justificatif = ?, mois_revenu = ?, annee_revenu = ? WHERE id_revenus_biens = ?");
    $stmt->execute([
      $data['id_bien'],
      $data['libelle_revenu_bien'],
      $data['montant_revenu'],
      $data['type_revenu_bien'],
      $data['origine_revenu'],
      $data['frequence'],
      $data['responsable_collecte'],
      $data['justificatif'],
      $data['mois_revenu'],
      $data['annee_revenu'],
      $id
    ]);
  }

  public function delete($id) {
    $stmt = $this->db->prepare("DELETE FROM revenus_biens WHERE id_revenus_biens = ?");
    $stmt->execute([$id]);
  }
}
?>
