<?php
require_once '/home/dykqnvjf/public_html/bewise/app/kernel/Database_connexion.php';

class RevenusModel {

  private $db;

  public function __construct() {
    try {
      $this->db = new PDO('mysql:host=localhost;dbname=dykqnvjf_gespes360', 'dykqnvjf_gespes360', 'dykqnvjf_gespes360');
      $this->db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
      $this->db->exec("SET NAMES 'utf8'");
    } catch (PDOException $e) {
      die("Erreur de connexion à la base de données : " . $e->getMessage());
    }
  }

  // 🔍 Tous les revenus (optionnel)
  public function getAllR() {
    return $this->db->query("SELECT * FROM revenus ORDER BY date_enregistrement DESC")->fetchAll(PDO::FETCH_ASSOC);
  }

  // 🔍 Revenus par utilisateur
  public function getByUser($id_receveur) {
    $stmt = $this->db->prepare("SELECT * FROM revenus WHERE id_receveur = ? ORDER BY date_enregistrement DESC");
    $stmt->execute([$id_receveur]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
  }

  // ➕ Enregistrement d’un revenu
  public function store(array $data) {
    $sql = "INSERT INTO revenus (
      id_receveur, id_donneur, id_compte, montant, source, libelle_revenu, categorie_revenu,
      mode_paiement, frequence, commentaires, responsable_suivi, justificatif,
      reference_transaction, date_revenu, statut
    ) VALUES (
      :id_receveur, :id_donneur, :id_compte, :montant, :source, :libelle_revenu, :categorie_revenu,
      :mode_paiement, :frequence, :commentaires, :responsable_suivi, :justificatif,
      :reference_transaction, :date_revenu, :statut
    )";
    $this->db->prepare($sql)->execute($data);
  }

  // 🔍 Trouver un revenu par ID
  public function find($id) {
    $stmt = $this->db->prepare("SELECT * FROM revenus WHERE id_revenu = ?");
    $stmt->execute([$id]);
    return $stmt->fetch(PDO::FETCH_ASSOC);
  }

  // ✏️ Mise à jour d’un revenu
  public function update($id, $data) {
    $sql = "UPDATE revenus SET 
      id_receveur = :id_receveur,
      id_donneur = :id_donneur,
      id_compte = :id_compte,
      montant = :montant,
      source = :source,
      libelle_revenu = :libelle_revenu,
      categorie_revenu = :categorie_revenu,
      mode_paiement = :mode_paiement,
      frequence = :frequence,
      commentaires = :commentaires,
      responsable_suivi = :responsable_suivi,
      justificatif = :justificatif,
      reference_transaction = :reference_transaction,
      date_revenu = :date_revenu,
      statut = :statut
    WHERE id_revenu = :id";

    $stmt = $this->db->prepare($sql);
    $data['id'] = $id;
    return $stmt->execute($data);
  }

  // ❌ Suppression d’un revenu
  public function delete($id) {
    $this->db->prepare("DELETE FROM revenus WHERE id_revenu = ?")->execute([$id]);
  }

  // 🔍 Revenu par ID (vue alternative)
  public function getRevenuById($id) {
    $sql = "SELECT * FROM revenus WHERE id_revenu = :id";
    $stmt = $this->db->prepare($sql);
    $stmt->execute([':id' => $id]);
    return $stmt->fetch(PDO::FETCH_ASSOC);
  }
}

?>
