<?php
require_once '/home/dykqnvjf/public_html/bewise/app/kernel/Database_connexion.php';


class DettesModel extends Database {
    
    public function __construct() {
        $this->pdo = new PDO(
            'mysql:host=localhost;dbname=dykqnvjf_gespes360;charset=utf8',
            'dykqnvjf_gespes360',
            'dykqnvjf_gespes360',
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
            ]
        );
    }

    public function getByUser(int $userId): array {
        $stmt = $this->pdo->prepare("
            SELECT * FROM dettes 
            WHERE id_contracteur = ? 
            ORDER BY date_enregistrement DESC
        ");
        $stmt->execute([$userId]);
        return $stmt->fetchAll();
    }



  public function getByContracteur($id_contracteur) {
    $sql = "SELECT * FROM dettes WHERE id_contracteur = ? ORDER BY date_enregistrement DESC";
    return $this->fetchAll($sql, [$id_contracteur]);
  }

  public function find($id) {
    $sql = "SELECT * FROM dettes WHERE id_dette = ? ORDER BY date_enregistrement DESC";
    return $this->fetch($sql, [$id]);
  }

  public function store($data) {
    $sql = "INSERT INTO dettes (
      id_contracteur, id_octroyeur, id_compte, libelle_dette, montant_emprunt,
      taux_d_interest, montant_remboursement, description, type_dette, origine_dette,
      garantie, statut, niveau_priorite, date_emprunt, date_remboursement, historique_remboursements
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    
    $params = [
      $data['id_contracteur'], $data['id_octroyeur'], $data['id_compte'], $data['libelle_dette'],
      $data['montant_emprunt'], $data['taux_d_interest'], $data['montant_remboursement'],
      $data['description'], $data['type_dette'], $data['origine_dette'], $data['garantie'],
      $data['statut'], $data['niveau_priorite'], $data['date_emprunt'], $data['date_remboursement'],
      $data['historique_remboursements']
    ];
    
    return $this->execute($sql, $params);
  }

  public function update($id, $data) {
    $sql = "UPDATE dettes SET
      id_octroyeur = ?, id_compte = ?, libelle_dette = ?, montant_emprunt = ?,
      taux_d_interest = ?, montant_remboursement = ?, description = ?, type_dette = ?,
      origine_dette = ?, garantie = ?, statut = ?, niveau_priorite = ?, date_emprunt = ?,
      date_remboursement = ?, historique_remboursements = ?
      WHERE id_dette = ?";
    
    $params = [
      $data['id_octroyeur'], $data['id_compte'], $data['libelle_dette'], $data['montant_emprunt'],
      $data['taux_d_interest'], $data['montant_remboursement'], $data['description'],
      $data['type_dette'], $data['origine_dette'], $data['garantie'], $data['statut'],
      $data['niveau_priorite'], $data['date_emprunt'], $data['date_remboursement'],
      $data['historique_remboursements'], $id
    ];
    
    return $this->execute($sql, $params);
  }

  public function delete($id) {
    $sql = "DELETE FROM dettes WHERE id_dette = ?";
    return $this->execute($sql, [$id]);
  }
}
