<?php

class ComptesModel {
    private $db;

    public function __construct() {
        require_once '/home/dykqnvjf/public_html/bewise/app/kernel/Database_connexion.php';
        $this->db = (new Database())->connect();
        $this->db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $this->db->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
    }

    public function getByUser($id_user) {
        $stmt = $this->db->prepare("SELECT * FROM comptes WHERE id_utilisateur = ? ORDER BY date_derniere_activite DESC");
        $stmt->execute([$id_user]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function find($id) {
        $stmt = $this->db->prepare("SELECT * FROM comptes WHERE id_compte = ? LIMIT 1");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;
    }

    public function store($data) {
        // Validation des champs obligatoires
        $requiredFields = ['id_utilisateur', 'nom_compte', 'type_compte', 'devise', 'solde'];
        foreach ($requiredFields as $field) {
            if (!isset($data[$field]) || $data[$field] === '') {
                throw new InvalidArgumentException("Le champ $field est requis");
            }
        }

        // Préparation des données avec valeurs par défaut
        $completeData = [
            'id_utilisateur' => $data['id_utilisateur'],
            'nom_compte' => $data['nom_compte'],
            'type_compte' => $data['type_compte'],
            'devise' => $data['devise'],
            'solde' => $data['solde'],
            'limite_decouvert' => $data['limite_decouvert'] ?? 0,
            'taux_interet' => $data['taux_interet'] ?? 0,
            'mode_ouverture' => $data['mode_ouverture'] ?? 'en ligne',
            'statut' => $data['statut'] ?? 'actif',  
        ];

        $sql = "INSERT INTO comptes (
            id_utilisateur, nom_compte, type_compte, devise, solde,  
            limite_decouvert, taux_interet, mode_ouverture, 
            date_derniere_activite, statut, date_creation
        ) VALUES (
            :id_utilisateur, :nom_compte, :type_compte, :devise, :solde, 
            :limite_decouvert, :taux_interet, :mode_ouverture, 
            NOW(), :statut, NOW()
        )";
        
        $stmt = $this->db->prepare($sql);
        return $stmt->execute($completeData);
    }

    public function update($id, $data) {
        $sql = "UPDATE comptes SET 
            nom_compte = :nom_compte,
            type_compte = :type_compte,
            devise = :devise,
            solde = :solde,
            limite_decouvert = :limite_decouvert,
            taux_interet = :taux_interet,
            mode_ouverture = :mode_ouverture,
            date_derniere_activite = COALESCE(:date_derniere_activite, NOW()),
            statut = :statut
        WHERE id_compte = :id_compte";

        $completeData = [
            'id_compte' => $id,
            'nom_compte' => $data['nom_compte'],
            'type_compte' => $data['type_compte'],
            'devise' => $data['devise'],
            'solde' => $data['solde'],
            'limite_decouvert' => $data['limite_decouvert'] ?? 0,
            'taux_interet' => $data['taux_interet'] ?? 0,
            'mode_ouverture' => $data['mode_ouverture'] ?? 'en ligne',
            'date_derniere_activite' => $data['date_derniere_activite'] ?? null,
            'statut' => $data['statut'] ?? 'actif'
        ];

        $stmt = $this->db->prepare($sql);
        return $stmt->execute($completeData);
    }

    public function delete($id) {
        $this->db->beginTransaction();
        
        try {
            $stmt = $this->db->prepare("DELETE FROM comptes WHERE id_compte = ?");
            $stmt->execute([$id]);
            
            $this->db->commit();
            return $stmt->rowCount() > 0;
        } catch (Exception $e) {
            $this->db->rollBack();
            throw $e;
        }
    }
}