<?php

class Request {
  public array $get;
  public array $post;
  public array $server;

  public function __construct(array $get, array $post, array $server) {
    $this->get = $get;
    $this->post = $post;
    $this->server = $server;
  }

  public function getUri(): string {
    return $this->server['REQUEST_URI'] ?? '/';
  }

  public function getMethod(): string {
    return strtoupper($this->server['REQUEST_METHOD'] ?? 'GET');
  }

  public function input(string $key): mixed {
    return $this->post[$key] ?? $this->get[$key] ?? null;
  }
}
?>