<?php



  class PrincipalRouter {


  // Correction chemin
  public function handleRequest($uri) {
      


    
    // Chemin de base absolu
    $basePath = '/home/dykqnvjf/public_html/bewise/app/controllers/';
    
    $uri = parse_url($uri, PHP_URL_PATH);
    $uri = str_replace('/bewise/public/index.php', '', $uri);

    // Route login
    if ($uri === '/' || $uri === '/index.php' || $uri === '/login') {
        require_once  '/home/dykqnvjf/public_html/bewise/app/controllers/UtilisateursController.php';
        (new UtilisateursController())->showLoginForm();
        return;
    }

    // ... (appliquer le même pattern pour toutes les routes)

    

// Routes pour UtilisateursController pour tous les actions ménées sur la tables utilisateurs et sessions

   //Authentification à la connexion 
    if ($uri === '/authenticate') {
        require_once $basePath . 'UtilisateursController.php';
        (new UtilisateursController())->authenticate();
        return;
    }

   //Affichage du formulaire d'enregistrement
    if ($uri === '/register') {
      require_once $basePath . 'UtilisateursController.php';
      (new UtilisateursController())->showRegisterForm();
      return;
    }

   //Enregistrement d'un nouvelle utilisateur
    if ($uri === '/store') {
      require_once $basePath . 'UtilisateursController.php';
      (new UtilisateursController())->storeUser();
      return;
    }

   // Affichage d'un profil d'utilisateur
    if ($uri === '/profil') {
      require_once $basePath . 'UtilisateursController.php';
      (new UtilisateursController())->showProfil();
      return;
    }  
    
    //Modification des données d'un utilisateur
    if ($uri === '/modifier_profil') {
      require_once $basePath . 'UtilisateursController.php';
      (new UtilisateursController())->showUpdateProfil();
      return;
    } 

   //Déconnexion d'un utilisateur
    if ($uri === '/logout') {
      require_once $basePath . 'UtilisateursController.php';
      (new UtilisateursController())->logout();
      return;
    }

    //Affichage du tableau de bord
    if ($uri === '/dashboard') {
      if (!isset($_SESSION['user'])) {
        header('Location: /login');
        exit;
      }
      require_once $basePath . 'UtilisateursController.php';
      (new UtilisateursController())->showDashboard();
      return;
    }

    // Exemple de route dynamique : modification d’un profil
    if (preg_match('#^/update_profil/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'UtilisateursController.php';
      (new UtilisateursController())->updateProfil($matches[1]);
      return;
    }



// Routes pour DepensesController pour tous les actions ménées sur la tables depenses

    //Affichage du formulaire de dépense
    if ($uri === '/depenses') {
      require_once $basePath . 'DepensesController.php';
      (new DepensesController())->show();
      return;
    }

    //Enregistrement de la dépense
    if ($uri === '/store_depense') {
      require_once $basePath . 'DepensesController.php';
      (new DepensesController())->store();
      return;
    }

    // Affichage du formulaire de modification d'une dépense
    if (preg_match('#^/edit_depense/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'DepensesController.php';
      (new DepensesController())->editView($matches[1]);
      return;
    }

    // Mise à jour d'une dépense existante
    if (preg_match('#^/update_depense/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'DepensesController.php';
      (new DepensesController())->update($matches[1]);
      return;
    }

    // Suppression d'une dépense existante
    if (preg_match('#^/delete_depense/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'DepensesController.php';
      (new DepensesController())->delete($matches[1]);
      return;
    }







// Routes pour ComptesController pour tous les actions ménées sur la tables comptes

    // Affichage de tous les comptes
    if ($uri === '/comptes') {
      require_once $basePath . 'ComptesController.php';
      (new ComptesController())->index();
      return;
    }

    // Affichage du formulaire de création d’un compte
    if ($uri === '/create_compte') {
      require_once $basePath . 'ComptesController.php';
      (new ComptesController())->create();
      return;
    }

    // Enregistrement d’un nouveau compte
    if ($uri === '/store_compte') {
      require_once $basePath . 'ComptesController.php';
      (new ComptesController())->store();
      return;
    }

    // Affichage du formulaire de modification d’un compte
    if (preg_match('#^/edit_compte/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'ComptesController.php';
      (new ComptesController())->edit($matches[1]);
      return;
    }

    // Mise à jour d’un compte existant
    if (preg_match('#^/update_compte/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'ComptesController.php';
      (new ComptesController())->update($matches[1]);
      return;
    }

    // Suppression d’un compte
    if (preg_match('#^/delete_compte/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'ComptesController.php';
      (new ComptesController())->delete($matches[1]);
      return;
    }




// Routes pour Epargne_ctController pour tous les actions ménées sur la tables epargne_ct

    // Affichage de toutes les épargnes CT
    if ($uri === '/epargne_ct') {
      require_once $basePath . 'Epargne_ctController.php';
      (new Epargne_ctController())->index();
      return;
    }

    // Affichage du formulaire de création d’une épargne CT
    if ($uri === '/create-epargne_ct') {
      require_once $basePath . 'Epargne_ctController.php';
      (new Epargne_ctController())->create();
      return;
    }

    // Enregistrement d’une nouvelle épargne CT
    if ($uri === '/store_epargne_ct') {
      require_once $basePath . 'Epargne_ctController.php';
      (new Epargne_ctController())->store();
      return;
    }

    // Affichage du formulaire de modification d’une épargne CT
    if (preg_match('#^/edit_epargne_ct/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'Epargne_ctController.php';
      (new Epargne_ctController())->edit($matches[1]);
      return;
    }

    // Mise à jour d’une épargne CT existante
    if (preg_match('#^/update_epargne_ct/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'Epargne_ctController.php';
      (new Epargne_ctController())->update($matches[1]);
      return;
    }

    // Suppression d’une épargne CT
    if (preg_match('#^/delete_epargne_ct/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'Epargne_ctController.php';
      (new Epargne_ctController())->delete($matches[1]);
      return;
    }



// Routes pour dettesController pour tous les actions ménées sur la tables dettes

    // Affichage de toutes les dettes
    if ($uri === '/dettes') {
      require_once $basePath . 'DettesController.php';
      (new DettesController())->index();
      return;
    }

    // Affichage du formulaire de création d’une dette
    if ($uri === '/create_dette') {
      require_once $basePath . 'DettesController.php';
      (new DettesController())->create();
      return;
    }

    // Enregistrement d’une nouvelle dette
    if ($uri === '/store_dette') {
      require_once $basePath . 'DettesController.php';
      (new DettesController())->store();
      return;
    }

    // Affichage du formulaire de modification d’une dette
    if (preg_match('#^/edit_dette/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'DettesController.php';
      (new DettesController())->edit($matches[1]);
      return;
    }

    // Mise à jour d’une dette existante
    if (preg_match('#^/update_dette/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'DettesController.php';
      (new DettesController())->update($matches[1]);
      return;
    }

    // Suppression d’une dette
    if (preg_match('#^/delete_dette/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'DettesController.php';
      (new DettesController())->delete($matches[1]);
      return;
    }





// Routes pour BiensController pour tous les actions ménées sur la tables biens

    // Affichage de tous les biens
    if ($uri === '/biens') {
      require_once $basePath . 'BiensController.php';
      (new BiensController())->index();
      return;
    }

    // Affichage du formulaire de création d’un bien
    if ($uri === '/create_bien') {
      require_once $basePath . 'BiensController.php';
      (new BiensController())->create();
      return;
    }

    // Enregistrement d’un nouveau bien
    if ($uri === '/store_bien') {
      require_once $basePath . 'BiensController.php';
      (new BiensController())->store();
      return;
    }

    // Affichage du formulaire de modification d’un bien
    if (preg_match('#^/edit_bien/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'BiensController.php';
      (new BiensController())->edit($matches[1]);
      return;
    }

    // Mise à jour d’un bien existant
    if (preg_match('#^/update_bien/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'BiensController.php';
      (new BiensController())->update($matches[1]);
      return;
    }

    // Suppression d’un bien
    if (preg_match('#^/delete_bien/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'BiensController.php';
      (new BiensController())->delete($matches[1]);
      return;
    }





// Routes pour Depenses_biensController pour tous les actions ménées sur la tables depenses_biens

    // Affichage de toutes les dépenses liées aux biens
    if ($uri === '/depenses_biens') {
      require_once $basePath . 'Depenses_BiensController.php';
      (new Depenses_biensController())->index();
      return;
    }

    // Affichage du formulaire de création d’une dépense bien
    if ($uri === '/create_depense_bien') {
      require_once $basePath . 'Depenses_BiensController.php';
      (new Depenses_biensController())->create();
      return;
    }

    // Enregistrement d’une nouvelle dépense bien
    if ($uri === '/store_depense_bien') {
      require_once $basePath . 'Depenses_BiensController.php';
      (new Depenses_biensController())->store();
      return;
    }

    // Affichage du formulaire de modification d’une dépense bien
    if (preg_match('#^/edit_depense_bien/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'Depenses_BiensController.php';
      (new Depenses_biensController())->edit($matches[1]);
      return;
    }

    // Mise à jour d’une dépense bien existante
    if (preg_match('#^/update_depense_bien/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'Depenses_BiensController.php';
      (new Depenses_biensController())->update($matches[1]);
      return;
    }

    // Suppression d’une dépense bien
    if (preg_match('#^/delete_depense_bien/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'Depenses_BiensController.php';
      (new Depenses_biensController())->delete($matches[1]);
      return;
    }

    // Filtrer les dépenses par bien
    if (preg_match('#^/depenses_biens/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'Depenses_BiensController.php';
      (new Depenses_biensController())->filterByBien($matches[1]);
      return;
    }





// Routes pour Revenus_biensController pour tous les actions ménées sur la tables revenus_biens

    // Liste des revenus liés aux biens
    if ($uri === '/revenus_biens') {
      require_once $basePath . 'Revenus_BiensController.php';
      (new Revenus_biensController())->index();
      return;
    }

    // Formulaire de création d’un revenu bien
    if ($uri === '/create_revenus_biens') {
      require_once $basePath . 'Revenus_BiensController.php';
      (new Revenus_biensController())->create();
      return;
    }

    // Enregistrement d’un nouveau revenu bien
    if ($uri === '/store_revenus_biens') {
      require_once $basePath . 'Revenus_BiensController.php';
      (new Revenus_biensController())->store();
      return;
    }

    // Formulaire de modification d’un revenu bien
    if (preg_match('#^/edit_revenus_biens/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'Revenus_BiensController.php';
      (new Revenus_biensController())->edit($matches[1]);
      return;
    }

    // Mise à jour d’un revenu bien existant
    if (preg_match('#^/update_revenus_biens/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'Revenus_BiensController.php';
      (new Revenus_biensController())->update($matches[1]);
      return;
    }

    // Suppression d’un revenu bien
    if (preg_match('#^/delete_revenus_biens/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'Revenus_BiensController.php';
      (new Revenus_biensController())->delete($matches[1]);
      return;
    }

    // Filtrer les revenus par bien
    if (preg_match('#^/revenus_biens/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'Revenus_BiensController.php';
      (new Revenus_biensController())->filterByBien($matches[1]);
      return;
    }





// Routes pour RevenusController pour tous les actions ménées sur la tables revenus

    // Liste des revenus généraux
    if ($uri === '/revenus') {
      require_once $basePath . 'RevenusController.php';
      (new RevenusController())->index();
      return;
    }

    // Formulaire de création d’un revenu
    if ($uri === '/create_revenu') {
      require_once $basePath . 'RevenusController.php';
      (new RevenusController())->create();
      return;
    }

    // Enregistrement d’un nouveau revenu
    if ($uri === '/store_revenu') {
      require_once $basePath . 'RevenusController.php';
      (new RevenusController())->store();
      return;
    }

    // Formulaire de modification d’un revenu
    if (preg_match('#^/edit_revenu/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'RevenusController.php';
      (new RevenusController())->edit($matches[1]);
      return;
    }

    // Mise à jour d’un revenu existant
    if (preg_match('#^/update_revenu/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'RevenusController.php';
      (new RevenusController())->update($matches[1]);
      return;
    }

    // Suppression d’un revenu
    if (preg_match('#^/delete_revenu/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'RevenusController.php';
      (new RevenusController())->delete($matches[1]);
      return;
    }





// Routes pour FinancerController pour tous les actions ménées sur la tables financer

    // Liste des financements de dépenses
    if ($uri === '/financements_depenses') {
      require_once $basePath . 'FinancerController.php';
      (new FinancerController())->indexDepenses();
      return;
    }

    // Enregistrement d’un nouveau financement de dépense
    if ($uri === '/store_financement_depense') {
      require_once $basePath . 'FinancerController.php';
      (new FinancerController())->storeFinancementDepense();
      return;
    }

    // Formulaire de modification d’un financement de dépense
    if (preg_match('#^/edit_financement_depense/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'FinancerController.php';
      (new FinancerController())->editFinancementDepense($matches[1]);
      return;
    }

    // Mise à jour d’un financement de dépense
    if (preg_match('#^/update_financement_depense/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'FinancerController.php';
      (new FinancerController())->updateFinancementDepense($matches[1]);
      return;
    }

    // Suppression d’un financement de dépense
    if (preg_match('#^/delete_financement_depense/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'FinancerController.php';
      (new FinancerController())->deleteFinancementDepense($matches[1]);
      return;
    }





// Routes pour EpargnerController pour tous les actions ménées sur la tables epargner

    // Liste des financements d’épargnes
    if ($uri === '/financements_epargnes') {
      require_once $basePath . 'EpargnerController.php';
      (new EpargnerController())->indexFinancements();
      return;
    }

    // Formulaire de création d’un financement d’épargne
    if ($uri === '/create_financement_epargne') {
      require_once $basePath . 'EpargnerController.php';
      (new EpargnerController())->createFinancement();
      return;
    }

    // Enregistrement d’un financement d’épargne
    if ($uri === '/store_financement_epargne') {
      require_once $basePath . 'EpargnerController.php';
      (new EpargnerController())->storeFinancement();
      return;
    }

    // Formulaire de modification d’un financement d’épargne
    if (preg_match('#^/edit_financement_epargne/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'EpargnerController.php';
      (new EpargnerController())->editFinancement($matches[1]);
      return;
    }

    // Mise à jour d’un financement d’épargne
    if (preg_match('#^/update_financement_epargne/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'EpargnerController.php';
      (new EpargnerController())->updateFinancement($matches[1]);
      return;
    }

    // Suppression d’un financement d’épargne
    if (preg_match('#^/delete_financement_epargne/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'EpargnerController.php';
      (new EpargnerController())->deleteFinancement($matches[1]);
      return;
    }


    // Routes pour EpargnerController pour tous les actions ménées sur la tables epargner
    
    // Liste des conseils
    if ($uri === '/conseils') {
      require_once $basePath . 'ConseilsController.php';
      (new ConseilsController())->ShowConseils();
      return;
    }
  
    // Route API pour le filtrage AJAX
    if ($uri === 'api/filter-conseils') {
        $conseilsController = new Conseils_UsersController($db);
        $conseilsController->filterConseils();
    }
   
    // Liste des conseils
    if ($uri === '/conseils_admin') {
      require_once $basePath . 'ConseilsController.php';
      (new ConseilsController())->index();
      return;
    }

    // Formulaire de création d’un conseil
    if ($uri === '/create_conseil') {
      require_once $basePath . 'ConseilsController.php';
      (new ConseilsController())->create();
      return;
    }

    // Enregistrement d’un nouveau conseil
    if ($uri === '/store_conseil') {
      require_once $basePath . 'ConseilsController.php';
      (new ConseilsController())->store();
      return;
    }

    // Formulaire de modification d’un conseil
    if (preg_match('#^/edit_conseil/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'ConseilsController.php';
      (new ConseilsController())->edit($matches[1]);
      return;
    }

    // Mise à jour d’un conseil
    if (preg_match('#^/update_conseil/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'ConseilsController.php';
      (new ConseilsController())->update($matches[1]);
      return;
    }

    // Suppression d’un conseil
    if (preg_match('#^/delete_conseil/([0-9]+)$#', $uri, $matches)) {
      require_once $basePath . 'ConseilsController.php';
      (new ConseilsController())->delete($matches[1]);
      return;
    }

    // Affichage d’un conseil aléatoire
    if ($uri === '/random_conseil') {
      require_once $basePath . 'ConseilsController.php';
      (new ConseilsController())->random();
      return;
    }

    // Affichage d’un conseil aléatoire
    if ($uri === '/statistiques') {
      require_once $basePath . 'StatistiquesController.php';
      $controller = new StatistiquesController();
       $controller->index();
      return;
    }


    // Route par défaut : erreur 404
            // Vue d'erreur simplifiée
    echo '<!DOCTYPE html>
    <html>
    <head>
        <title>Erreur 404 - BeWise</title>
        <style>
            body { font-family: Arial, sans-serif; text-align: center; padding: 50px; }
            .error-container { max-width: 600px; margin: 0 auto; }
            .error-code { color: #d9534f; font-size: 72px; }
        </style>
    </head>
    <body>
        <div class="error-container">
            <div class="error-code">404</div>
            <h2>Attention, cette route mauvaise route.</h2>
            <p>Impossible de joindre cette ressource. Veuillez vous connecter ou vous inscrire.</p>
            <a href="../index.php/login">Connexion</a> / ou / <a href="../index.php/register">Inscription</a>
        </div>
    </body>
    </html>';
    http_response_code(404);
    echo "<h2>Routeur Erreur 404</h2><p>Page introuvable.</p>";
    


  }
}

?>