<?php
class StatistiquesController {
    private $model;
    
    public function __construct() {
        require_once '/home/dykqnvjf/public_html/bewise/app/models/StatistiquesModel.php';
        $this->model = new StatistiquesModel();
    }
    
    public function index() {
        $id_utilisateur = $_SESSION['user']['id_utilisateur'] ?? null;
        if (!$id_utilisateur) {
            header('Location: ../index.php/login');
            exit();
        }
        
        $data = [
            'sessions' => $this->model->getSessionsStats($id_utilisateur),
            'revenus' => [
                'donnes' => [
                    'liste' => $this->model->getRevenusDonnes($id_utilisateur),
                    'totaux' => $this->model->getTotauxRevenusDonnes($id_utilisateur)
                ],
                'recus' => [
                    'liste' => $this->model->getRevenusRecus($id_utilisateur),
                    'totaux' => $this->model->getTotauxRevenusRecus($id_utilisateur)
                ]
            ],
            'dettes' => [
                'octroyees' => [
                    'liste' => $this->model->getDettesOctroyees($id_utilisateur),
                    'totaux' => $this->model->getTotauxDettesOctroyees($id_utilisateur)
                ],
                'recues' => [
                    'liste' => $this->model->getDettesRecues($id_utilisateur),
                    'totaux' => $this->model->getTotauxDettesRecues($id_utilisateur)
                ]
            ],
            'gains' => [
                'totaux' => $this->model->getTotauxGains($id_utilisateur)
            ],
            'financements' => [
                'depenses' => $this->model->getFinancementsDepenses($id_utilisateur),
                'epargnes' => $this->model->getFinancementsEpargnes($id_utilisateur)
            ]
        ];
        
        require_once '/home/dykqnvjf/public_html/bewise/app/views/StatistiquesView.php';
    }
}
?>