<?php

class RevenusController {
  private $model;
  private $userModel;

  public function __construct() {
    $this->model = new RevenusModel();
    $this->userModel = new UtilisateursModel();
  }

  // Affiche la liste des revenus de l'utilisateur connecté
  public function index() {
    if (session_status() === PHP_SESSION_NONE) session_start();
    if (!isset($_SESSION['user'])) {
      header('Location: /login');
      exit;
    }

    $id_receveur = $_SESSION['user']['id_utilisateur'];
    $revenus = $this->model->getByUser($id_receveur);
    $utilisateurs = $this->userModel->getAllU();

    $compteModel = new ComptesModel();
    $comptes = $compteModel->getByUser($id_receveur);

    require '/home/dykqnvjf/public_html/bewise/app/views/RevenusView.php';
  }

  // Enregistre un nouveau revenu
  public function store() {
    @session_start();
    $data = $_POST;
    $data['id_receveur'] = $_SESSION['user']['id_utilisateur'];
    $this->model->store($data);

    $_SESSION['success_message'] = "✅ Revenu enregistré avec succès.";
    header('Location: ../index.php/revenus');
    exit;
  }

  // Affiche le formulaire de modification
  public function edit($id) {
    @session_start();
    $revenu = $this->model->find($id);
    $utilisateurs = $this->userModel->getAllU();

    $compteModel = new ComptesModel();
    $comptes = $compteModel->getByUser($_SESSION['user']['id_utilisateur']);

    require '/home/dykqnvjf/public_html/bewise/app/views/EditRevenuView.php';
  }






  // Met à jour un revenu existant
  public function update($id) {
    @session_start();
    $this->model->update($id, $_POST);
    header('Location: ../revenus');
    exit;
  }

  // Supprime un revenu
  public function delete($id) {
    @session_start();
    $this->model->delete($id);
    header('Location: ../revenus');
    exit;
  }

  // Vue alternative pour modification
  public function editView($id) {
    $model = new RevenusModel();
    $revenu = $model->getRevenuById($id);

    if (!$revenu) {
      http_response_code(404);
      echo "Revenu introuvable.";
      return;
    }

    $utilisateurModel = new UtilisateursModel();
    $utilisateurs = $utilisateurModel->getAllU();

    require_once '/home/dykqnvjf/public_html/bewise/app/views/EditRevenuView.php';
  }
}

?>
