<?php

require_once '/home/dykqnvjf/public_html/bewise/app/models/FinancerModel.php';

class FinancerController
{
    private $model;

    public function __construct()
    {
        $this->model = new FinancerModel();
    }

    // 🧾 Liste des financements liés aux dépenses
    public function indexDepenses() {
      $model = new FinancerModel();

      @session_start();
      $id_user = $_SESSION['user']['id_utilisateur']; // ou autre méthode pour identifier l'utilisateur connecté

      $financements = $model->getAllDepenseFinancements($id_user);

      $revenus = $model->getRevenusByUser($id_user);
      $montant = $model->getRevenusByUser($id_user);

      $gains = $model->getGainsByUser($id_user);
      $montant_gain = $model->getGainsByUser($id_user);
      
      $depenses = $model->getDepensesByUser($id_user);

      require '/home/dykqnvjf/public_html/bewise/app/views/FinancementsDepensesView.php';
    }


    public function storeFinancementDepense() {
      if (session_status() === PHP_SESSION_NONE) session_start();
      
      $this->model1 = new FinancerModel();
      $data = [
        'libelle_financement' => $_POST['libelle_financement'],
        'montant_f' => $_POST['montant_f'],
        'date_financer' => $_POST['date_financer'],
        'heure_financer' => $_POST['heure_financer'],
        'type_financement' => $_POST['type_financement'],
        'objectif_financement' => $_POST['objectif_financement'],
        'duree_financement' => $_POST['duree_financement'],
        'impact_financier' => $_POST['impact_financier'],
        'methode_allocation' => $_POST['methode_allocation'],
        'id_revenu' => $_POST['id_revenu'] ?: null,
        'id_gain' => $_POST['id_gain'],
        'id_depense' => $_POST['id_depense'] ?: null
      ];

      $this->model1->store_financement($data);
      $_SESSION['success_message'] = "✅ Financement enregistré avec succès.";
      header('Location: ../index.php/financements_depenses');
      exit;
    }


    // ✏️ Formulaire de modification
    public function editFinancementDepense($id)
    {
      
      $financement = $this->model->getById($id);
        
      $model = new FinancerModel();

      @session_start();
      $id_user = $_SESSION['user']['id_utilisateur']; // ou autre méthode pour identifier l'utilisateur connecté

      $financements = $model->getAllDepenseFinancements($id_user);

      $revenus = $model->getRevenusByUser($id_user);
      $montant = $model->getRevenusByUser($id_user);

      $gains = $model->getGainsByUser($id_user);
      $montant_gain = $model->getGainsByUser($id_user);
      
      $depenses = $model->getDepensesByUser($id_user);        
        require_once '/home/dykqnvjf/public_html/bewise/app/views/EditFinancementDepenseView.php';
    }


    // 🔄 Mise à jour du financement
    public function updateFinancementDepense($id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'libelle_financement' => $_POST['libelle_financement'],
                'montant_f' => $_POST['montant_f'],
                'date_financer' => $_POST['date_financer'],
                'heure_financer' => $_POST['heure_financer'],
                'type_financement' => $_POST['type_financement'],
                'objectif_financement' => $_POST['objectif_financement'],
                'duree_financement' => $_POST['duree_financement'],
                'impact_financier' => $_POST['impact_financier'],
                'methode_allocation' => $_POST['methode_allocation'],
                'id_revenu' => $_POST['id_revenu'] ?? null,
                'id_gain' => $_POST['id_gain'],
                'id_depense' => $_POST['id_depense'] ?? null
            ];

            $this->model->update($id, $data);
            header('Location: ../financements_depenses');
            exit;
        }
    }

    // 🗑️ Suppression
    public function deleteFinancementDepense($id)
    {
        $this->model->delete($id);
        header('Location: ../financements_depenses');
        exit;
    }
}
?>