<?php

require_once '/home/dykqnvjf/public_html/bewise/app/models/EpargnerModel.php';

class EpargnerController
{
    private $model;

    public function __construct()
    {
        $this->model = new EpargnerModel();
    }

    // 🧾 Liste des financements d’épargnes
    public function indexFinancements() {
        @session_start();
        $id_user = $_SESSION['user']['id_utilisateur'];

        $financements = $this->model->getAllEpargneFinancements($id_user);
        $epargnes = $this->model->getEpargnesByUser($id_user);
        $revenus = $this->model->getRevenusByUser($id_user);
        $gains = $this->model->getGainsByUser($id_user);

        require '/home/dykqnvjf/public_html/bewise/app/views/FinancementsEpargnesView.php';
    }

    // 💾 Enregistrement d’un financement d’épargne
    public function storeFinancement() {
        if (session_status() === PHP_SESSION_NONE) session_start();

        $data = [
            'id_epargne_ct' => $_POST['id_epargne_ct'],
            'id_gain' => $_POST['id_gain'] ?: null,
            'id_revenu' => $_POST['id_revenu'] ?: null,
            'libelle_epargner' => $_POST['libelle_epargner'],
            'montant' => $_POST['montant'],
            'date_epargne' => $_POST['date_epargne'],
            'heure_epargne' => $_POST['heure_epargne'],
            'origine_fonds' => $_POST['origine_fonds'],
            'moyen_transfer' => $_POST['moyen_transfer'],
            'justificatif_depot' => $_POST['justificatif_depot'],
            'responsable_enregistrement' => $_POST['responsable_enregistrement'],
            'note_strategique' => $_POST['note_strategique']
        ];

        $this->model->store($data);
        $_SESSION['success_message'] = "✅ Financement d’épargne enregistré avec succès.";
        header('Location: ../index.php/financements_epargnes');
        exit;
    }

    // ✏️ Formulaire de modification
    public function editFinancement($id)
    {
        
        @session_start();
        $id_user = $_SESSION['user']['id_utilisateur'];

        $financements = $this->model->getAllEpargneFinancements($id_user);
        $epargnes = $this->model->getEpargnesByUser($id_user);
        $revenus = $this->model->getRevenusByUser($id_user);
        $gains = $this->model->getGainsByUser($id_user);
        
        $financement = $this->model->getById($id);
        require_once '/home/dykqnvjf/public_html/bewise/app/views/EditFinancementEpargneView.php';
    }

    // 🔄 Mise à jour du financement
    public function updateFinancement($id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'id_epargne_ct' => $_POST['id_epargne_ct'],
                'id_gain' => $_POST['id_gain'] ?: null,
                'id_revenu' => $_POST['id_revenu'] ?: null,
                'libelle_epargner' => $_POST['libelle_epargner'], 
                'montant' => $_POST['montant'],
                'date_epargne' => $_POST['date_epargne'],
                'heure_epargne' => $_POST['heure_epargne'],
                'origine_fonds' => $_POST['origine_fonds'],
                'moyen_transfer' => $_POST['moyen_transfer'],
                'justificatif_depot' => $_POST['justificatif_depot'],
                'responsable_enregistrement' => $_POST['responsable_enregistrement'],
                'note_strategique' => $_POST['note_strategique']
            ];

            $this->model->update($id, $data);
            header('Location: ../financements_epargnes');
            exit;
        }
    }

    // 🗑️ Suppression
    public function deleteFinancement($id)
    {
        $this->model->delete($id);
        header('Location: ../financements_epargnes');
        exit;
    }
}
?>
