<?php

class DepensesController {
    private $model;
    private $userModel;

    public function __construct() {
        $this->model = new DepensesModel();
        $this->userModel = new UtilisateursModel();
        $this->checkSession();
    }

    private function checkSession() {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
        
        if (!isset($_SESSION['user'])) {
            $this->setNotification('error', 'Veuillez vous connecter pour accéder à cette page');
            header('Location: ../index.php/login');
            exit;
        }
    }

    private function setNotification($type, $message) {
        $_SESSION['flash'] = [
            'type' => $type,
            'message' => $message
        ];
    }

    public function show() {
        $id_faiseur = $_SESSION['user']['id_utilisateur'];
        $depenses = $this->model->getByUser($id_faiseur);
        $utilisateurs = $this->userModel->getAllU();
        
        require '/home/dykqnvjf/public_html/bewise/app/views/DepensesView.php';
    }

    public function store() {
        try {
            $data = $_POST;
            $data['id_faiseur'] = $_SESSION['user']['id_utilisateur'];
            
            if ($this->model->store($data)) {
                $this->setNotification('success', 'Dépense enregistrée avec succès!');
            } else {
                throw new Exception("Erreur lors de l'enregistrement de la dépense");
            }
        } catch (Exception $e) {
            $this->setNotification('error', $e->getMessage());
        }
        
        header('Location: ../index.php/depenses');
        exit;
    }

    public function edit($id) {
        $depense = $this->model->find($id);
        
        if (!$depense) {
            $this->setNotification('error', 'Dépense introuvable');
            header('Location: ../depenses');
            exit;
        }
        
        $utilisateurs = $this->userModel->getAllU(); // Changé de getAll() à getAllU()
        require '/home/dykqnvjf/public_html/bewise/app/views/EditDepenseView.php';
    }

    public function update($id) {
        try {
            $data = $_POST;
            
            if (!isset($data['mode_paiement'])) $data['mode_paiement'] = null;
            if (!isset($data['description'])) $data['description'] = null;
            if (!isset($data['piece_justificative'])) $data['piece_justificative'] = null;
            
            if ($this->model->update($id, $data)) {
                $this->setNotification('success', 'Dépense mise à jour avec succès');
            } else {
                throw new Exception("Erreur lors de la mise à jour");
            }
        } catch (Exception $e) {
            $this->setNotification('error', $e->getMessage());
            
        }
        
        header('Location: ../depenses');
        exit;
    }


    public function delete($id) {
        try {
            if ($this->model->delete($id)) {
                $this->setNotification('success', 'Dépense supprimée avec succès');
            } else {
                throw new Exception("Erreur lors de la suppression");
            }
        } catch (Exception $e) {
            $this->setNotification('error', 'Impossible de supprimer car liées à des financements');
        }
        
        header('Location: ../depenses');
        exit;
    }

    public function editView($id) {
        $depense = $this->model->getDepenseById($id);

        if (!$depense) {
            $this->setNotification('error', 'Dépense introuvable');
            header('Location: ../depenses');
            exit;
        }

        $utilisateurs = $this->userModel->getAllU();
        require_once '/home/dykqnvjf/public_html/bewise/app/views/EditDepenseView.php';
    }
}
?>