<?php


class ConseilsController
{
    private $model;

    public function __construct() {
        require_once __DIR__.'/../models/ConseilsModel.php';
        $this->model = new ConseilsModel();
    }




    // 🔍 Liste des conseils
    public function index()
    {
        $conseils = $this->model->getAll();
        require_once '/home/dykqnvjf/public_html/bewise/app/views/ConseilsView'; 
    }



    // ➕ Formulaire de création
    public function create()
    {
        require_once '/home/dykqnvjf/public_html/bewise/app/views/Conseils/create.php';
    }


    // ✅ Enregistrement d’un nouveau conseil
    public function store()
    {
        $data = [
            'message_conseil' => $_POST['message_conseil'] ?? '',
            'type_conseil' => $_POST['type_conseil'] ?? '',
        ];

        $this->model->insert($data);
        header('Location: ../conseils');
    }




    // ✏️ Formulaire de modification
    public function edit($id)
    {
        $conseil = $this->model->find($id);
        require_once '/home/dykqnvjf/public_html/bewise/app/views/Conseils/edit.php';
    }



    // 🔄 Mise à jour
    public function update($id)
    {
        $data = [
            'message_conseil' => $_POST['message_conseil'] ?? '',
            'type_conseil' => $_POST['type_conseil'] ?? '',
        ];

        $this->model->update($id, $data);
        header('Location: /conseils');
    }



    // 🗑️ Suppression
    public function delete($id)
    {
        $this->model->delete($id);
        header('Location: /conseils');
    }



    // 🎲 Conseil aléatoire
    public function random()
    {
        $conseil = $this->model->getRandom();
        echo json_encode($conseil);
    }
 







    public function ShowConseils() {
        // Initialisation session
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }

        // Vérification authentification
        if (!isset($_SESSION['user']['id_utilisateur'])) {
            header('Location: ../login');
            exit();
        }

        $conseils = $this->model->getAll();
            
        require_once '/home/dykqnvjf/public_html/bewise/app/views/ConseilsView.php';

    }

    private function loadView($conseils, $filters) {
        // Préparation des données pour la vue
        $viewData = [
            'conseils' => $conseils,
            'filters' => $filters,
            'typesConseils' => $this->model->getTypesConseils()
        ];

        // Chemin absolu vers la vue
        $viewPath = __DIR__.'/../views/conseils/ConseilsView.php';

        if (file_exists($viewPath)) {
            extract($viewData);
            require_once $viewPath;
        } else {
            throw new Exception("Vue introuvable: ".$viewPath);
        }
    }

    private function loadErrorView() {
        // Vue d'erreur simplifiée
        echo '<!DOCTYPE html>
        <html>
        <head>
            <title>Erreur</title>
            <style>
                body { font-family: Arial, sans-serif; text-align: center; padding: 50px; }
                .error-container { max-width: 600px; margin: 0 auto; }
                .error-code { color: #d9534f; font-size: 72px; }
            </style>
        </head>
        <body>
            <div class="error-container">
                <div class="error-code">500</div>
                <h2>Erreur de chargement des conseils</h2>
                <p>Nous rencontrons des difficultés techniques. Veuillez réessayer plus tard.</p>
                <a href="../index.php/dashboard">Retour au tableau de bord</a>
            </div>
        </body>
        </html>';
    } 
    
    
}
?>