<?php
require_once '/home/dykqnvjf/public_html/bewise/app/models/ComptesModel.php'; 

class ComptesController {
    private $model;

    public function __construct() {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
        
        // Vérification de la connexion
        if (!isset($_SESSION['user']['id_utilisateur'])) {
            header('Location: ../index.php/login');
            exit;
        }
        
        $this->model = new ComptesModel();
    }

    private function setFlashMessage($type, $message) {
        $_SESSION['flash'] = [
            'type' => $type,
            'message' => $message,
            'displayed' => false // Ajout d'un flag pour suivre l'affichage
        ];
    }

    private function getFlashMessage() {
        if (isset($_SESSION['flash']) && !$_SESSION['flash']['displayed']) {
            $_SESSION['flash']['displayed'] = true; // Marquer comme affiché
            return $_SESSION['flash'];
        }
        return null;
    }

    public function index() {
        try {
            $comptes = $this->model->getByUser($_SESSION['user']['id_utilisateur']);
            $flash = $this->getFlashMessage(); // Utilisation de la nouvelle méthode
            
            require_once '/home/dykqnvjf/public_html/bewise/app/views/ComptesView.php';
            
            // Nettoyage après affichage
            if (isset($_SESSION['flash']) && $_SESSION['flash']['displayed']) {
                unset($_SESSION['flash']);
            }
        } catch (Exception $e) {
            $this->setFlashMessage('danger', 'Erreur lors du chargement des comptes');
            header('Location: ../index.php/dashboard');
            exit;
        }
    }



    private function checkAuthentication() {
        if (!isset($_SESSION['user']['id_utilisateur'])) {
            $this->setFlashMessage('danger', 'Veuillez vous connecter');
            header('Location: ../index.php/login');
            exit;
        }
    }



    public function edit($id) {
        $this->checkAuthentication();
        
        try {
            $compte = $this->model->find($id);
            
            // Vérification que le compte appartient à l'utilisateur
            if (!$compte || $compte['id_utilisateur'] != $_SESSION['user']['id_utilisateur']) {
                $this->setFlashMessage('danger', 'Compte introuvable');
                header('Location: ../comptes');
                exit;
            }
            
            $flash = $_SESSION['flash'] ?? null;
            unset($_SESSION['flash']);
            
            require_once '/home/dykqnvjf/public_html/bewise/app/views/EditComptesView.php';
        } catch (Exception $e) {
            $this->setFlashMessage('danger', 'Compte introuvable');
            header('Location: ../comptes');
            exit;
        }
    }

    public function store() {
        $this->checkAuthentication();
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            try {
                $data = $_POST;
                $data['id_utilisateur'] = $_SESSION['user']['id_utilisateur'];
                
                if ($this->model->store($data)) {
                    $this->setFlashMessage('success', 'Compte créé avec succès');
                } else {
                    $this->setFlashMessage('warning', 'Aucune modification effectuée');
                }
            } catch (Exception $e) {
                $this->setFlashMessage('danger', 'Erreur lors de la création du compte: ' . $e->getMessage());
            }
            header('Location: ../index.php/comptes');
            exit;
        }
    }

    public function update($id) {
        $this->checkAuthentication();
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            try {
                // Vérification que le compte appartient à l'utilisateur
                $compte = $this->model->find($id);
                if (!$compte || $compte['id_utilisateur'] != $_SESSION['user']['id_utilisateur']) {
                    $this->setFlashMessage('danger', 'Compte introuvable');
                    header('Location: ../comptes');
                    exit;
                }
                
                $data = $_POST;
                if ($this->model->update($id, $data)) {
                    $this->setFlashMessage('success', 'Compte mis à jour avec succès');
                } else {
                    $this->setFlashMessage('warning', 'Aucune modification effectuée');
                }
            } catch (Exception $e) {
                $this->setFlashMessage('danger', 'Erreur lors de la mise à jour du compte');
            }
            
            header('Location: ../comptes');
            exit;
        }
    }

    public function delete($id) {
        $this->checkAuthentication();
        
        try {
            // Vérification que le compte appartient à l'utilisateur
            $compte = $this->model->find($id);
            if (!$compte || $compte['id_utilisateur'] != $_SESSION['user']['id_utilisateur']) {
                $this->setFlashMessage('danger', 'Compte introuvable');
                header('Location: ../comptes');
                exit;
            }
            
            if ($this->model->delete($id)) {
                $this->setFlashMessage('success', 'Compte supprimé avec succès');
            } else {
                $this->setFlashMessage('danger', 'Erreur lors de la suppression du compte');
            }
        } catch (Exception $e) {
            $this->setFlashMessage('danger', 'Erreur critique lors de la suppression');
        }
        header('Location: ../comptes');
        exit;
    }
}
?>